const winston = require('winston');

const logger = winston.createLogger({
    level: 'info', // Set the minimum log level (e.g., 'debug', 'warn', 'error')
    format: winston.format.combine(
        winston.format.timestamp({ format: 'YYYY-MM-DD HH:mm:ss' }),
        winston.format.json()
    ),
    transports: [
        // Local File Transport (for errors)
        new winston.transports.File({ filename: 'logs/error.log', level: 'error' }),
        // Local File Transport (for development)
        new winston.transports.File({ filename: 'logs/dev.log', level: 'debug' }),
        // Production Transport (configure accordingly)
        new winston.transports.File({ filename: 'logs/production.log', level: 'info' })
    ]
});

module.exports = logger;