const express = require("express");
const router = express.Router();
const db = require("../../utils/db");
const moment = require("moment");
const { verifyToken } = require("../middleware/verifyToken");
const { isUndefined } = require("lodash");

// router.post("/punchIn", verifyToken, async (req, res) => {
router.post("/punchIn", async (req, res) => {
  const timestamp = moment
    .utc(Date())
    .add(5,'hours')                   // Adjust Server Time
    .format("MM/DD/YYYY HH:mm:ss");
  var dateIn;
  if (moment.utc(Date()).hour() < 4) {
    dateIn = moment.utc(Date()).add(5,'hours').subtract(1, "days").format("MM/DD/YYYY");
    // dateIn = moment.utc(Date()).add(9,'hours').subtract(1, "days").format("MM/DD/YYYY");
  } else {
    dateIn = moment.utc(Date()).add(5,'hours').format("MM/DD/YYYY");
  }

  const query = {
    getShiftQuery: `
      SELECT * FROM Shift
        WHERE (
          TIME(STR_TO_DATE(startTime, '%H:%m:%s')) <= '${moment
            .utc(timestamp)
            .format("HH:mm:ss")}'
          AND TIME(STR_TO_DATE(endTime, '%H:%m:%s')) > '${moment
            .utc(timestamp)
            .format("HH:mm:ss")}'
        )
        OR (
          TIME(STR_TO_DATE(startTime, '%H:%m:%s')) > TIME(STR_TO_DATE(endTime, '%H:%m:%s')) 
          AND (
              TIME('${moment
                .utc(timestamp)
                .format("HH:mm:ss")}') >= TIME(STR_TO_DATE(startTime, '%H:%m:%s'))
              OR TIME('${moment
                .utc(timestamp)
                .format("HH:mm:ss")}') < TIME(STR_TO_DATE(endTime, '%H:%m:%s'))
            )
        );`,
    searchAttendanceQuery: ``,
    punchInQuery: "",
  };

  const userId = req.body?.userId;
  const deviceName = req.body?.deviceName;
  console.log("req.body >>> ", req.body);
  console.log("userId >>> ", userId);
  console.log("deviceName >>> ", deviceName);

  if(isUndefined(userId) || isUndefined(deviceName)){
    res.status(404).send({
      message: ("Required Data is Missing"),
    });
  }
  else{
    await db.getConnection(async (err, connection) => {
      if (err) {
        console.log("database not connected error: >>>", err);
        throw err;
      }

      await connection.query(query.getShiftQuery, (err, shiftDate) => {
        if (err) {
          console.log("error from GetShift  >>>", err);
          connection.release();
          res.status(404).send({
            message: ("error from GetShift  >>>", err),
          });
        } else {
          const shift = shiftDate[0]?.shiftName;
          
          // This Query Select data only with this condition "Agar Selected Device me Same date and shift me koi entry ho ya koi entry jis me punch out na huwa ho"
          // query.searchAttendanceQuery = `
          // SELECT * FROM attendance 
          // where 
          //     deviceName = '${deviceName}' AND
          //     ((date = '${dateIn}' AND shift = '${shift}') OR 
          //     punchOut IS NULL)`;
          query.searchAttendanceQuery = `
          SELECT * FROM attendance 
          where 
              deviceName = '${deviceName}' AND
              ((date = '${dateIn}' AND shift = '${shift}' AND userId=${userId}) OR 
              punchOut IS NULL)`;

          connection.query(query.searchAttendanceQuery, (err, attendanceData) => {
            if (err) {
              console.log("error from Search Attendance  >>>", err);
              connection.release();
              res.status(404).send({
                message: ("error from Search Attendance  >>>", err),
              });
            } else {
              console.log("Search Query >>> ", query.searchAttendanceQuery);
              console.log("Result >>> ", attendanceData);
              if (attendanceData.length > 0) {
                connection.release();
                res.status(208).send({
                  message: "Already Punch In",
                  data: attendanceData,
                });
              } else {
                query.punchInQuery = `
                          INSERT INTO attendance (userId, date, shift, punchIn, deviceName) 
                          VALUES (
                          '${userId}','${dateIn}', '${shift}','${timestamp}', '${deviceName}'
                          )`;
                connection.query(query.punchInQuery, (err, punchInData) => {
                  connection.release();
                  if (err) {
                    console.log("error from PunchIn  >>>", err);
                    res.status(404).send({
                      message: ("error from PunchIn  >>>", err),
                    });
                  } else {
                    res.status(200).send({
                      message: "Success",
                      data: punchInData,
                    });
                  }
                });
              }
            }
          });
        }
      });
    });
  }
});

module.exports = router;
