const express = require("express");
const router = express.Router();
const db = require("../../utils/db");
const bcrypt = require("bcryptjs");
const { verifyTokenAndAdmin } = require("../middleware/verifyToken");

router.post("/createUser", verifyTokenAndAdmin, (req, res) => {
  // router.post("/createUser", (req, res) => {
  const username = req.body.username;
  const email = req.body.email;
  const password = req.body.password;
  const userRole = req.body.userRole;
  const lineId = req.body.lineId || "";

  bcrypt.hash(password, 14, function (err, hash) {
    if (err) {
      console.log("error from create user >>>", err);
      return res.status(401).json({
        message: "Error while hashing",
        error: err,
      });
    } else {
      db.getConnection((err, connection) => {
        if (err) {
          console.log("database not connected error: >>>", err);
        }
        const query = `INSERT INTO Users (email,username,password,userRole, lineId) values ("${email}","${username}","${hash}",'${userRole}', ${lineId});`;
        connection.query(query, (err, result) => {
          connection.release();
          if (err) {
            console.log("error ==>", err);
            if (err.code === "ER_DUP_ENTRY") {
              res.status(409).json({
                message: "Duplicate User",
                results: "Failed",
              });
            } else if (err.code === "ENOTFOUND") {
              res.status(404).json({
                message: "Internet Connection Failed",
                results: "Failed",
              });
            } else {
              console.log(err);
              res.status(401).json({
                message: "User creation failed",
                results: "Failed",
              });
            }
          } else {
            res.status(200).json({
              message: "User Created Successfully",
              results: "Success",
            });
          }
        });
      });
    }
  });
});

module.exports = router;
