const express = require("express");
const router = express.Router();
const db = require("../../utils/db");
const { verifyToken } = require("../middleware/verifyToken");
const { isUndefined } = require("lodash");

// Temp API to manage previous Data
// router.get("/getCurruntStatus", verifyToken, (req, res) => {
router.get("/recordEvent", (req, res) => {

  const event = {
    deviceName:'',
    eventName:'',
    startTime:'',
    endTime:'',
    duration:'',
    totalProduction:'',
    productionAtStart:'',
    productionAtEnd:'',
    comments:'',
    Status:'',
    speed:'',
    userId:'',
    orderId:'',
    stopId:'',
    timestamp:'',
  }

  eventData = [];

  console.log("recordEvent API");
  const getDeviceData = `
  SELECT 
    dd.id, 
    dd.deviceName, 
    dd.deviceStatus, 
    dd.productCount, 
    dd.machineSpeed, 
    dd.orderId, 
    dd.timestamp, 
    COALESCE(s.id, 0) AS stopId 
  FROM 
    DeviceData dd 
  LEFT JOIN 
    Stops s ON dd.id = s.deviceDataId 
  WHERE 
    STR_TO_DATE(dd.timestamp, '%m/%d/%Y %H:%i:%s') BETWEEN '2024-04-09 07:00:00' AND '2024-04-09 07:10:00' 
  ORDER BY 
    dd.id ASC`;

  db.getConnection((err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      throw err;
    }
    connection.query(getDeviceData, async (err, data) => {
      if (err) {
        connection.release();
        console.log("Error: >>>", err);
        res.status(404).send({
          message: "Not Found",
          error: err,
        });
      } else {

        let previousState; 
        let newData = true;
        let startDate, endDate;
        let eventQuery, eventId;
        console.log("previousState > ", previousState);
        await data.forEach(async record => {
          newData = isUndefined(previousState)?true:(previousState !== record.deviceStatus)? true:false
          isUndefined(previousState)?'':newData?eventData.push(event):''
          previousState = record.deviceStatus

          let eventName = record.deviceStatus==1?"running":"stop"
          let startDate; 
          newData?startDate = record.timestamp:''
          

          if(newData){
            eventQuery = `
            INSERT INTO events (
              deviceName, eventName, startTime,
              productionAtStart, orderId, stopId, 
              timestamp
            ) VALUES (
                '${record.deviceName}','${eventName}','${record.timestamp}',
                '${record.productCount}','${record.orderId}','${record.stopId}',
                '${record.timestamp}'
            )`
          }
          else{
            eventQuery = `
            UPDATE events SET 
              endTime='${record.timestamp}',duration='${record.timestamp}',
              totalProduction='${record.productCount}',productionAtEnd='${record.productCount}',
              speed='${record.machineSpeed}',timestamp='${record.timestamp}' 
            WHERE 
              id='${eventId}'
            `
          }

          
          console.log("eventQuery >>> ", eventQuery);
          await connection.query(eventQuery, (err, data) => {
            if (err) {
              connection.release();
              console.log("Error: >>>", err);
              res.status(404).send({
                message: "Not Found",
                error: err,
              });
            } else {
              if(newData){
                console.log("event Added Successfully at id: ", data.insertId);
                eventId = data.insertId;
              }
              else{
                console.log("event Updated Successfully at id: ", eventId);
              }
            }
          });
         
        });
        connection.release();
        eventData.push(event)
        res.status(200).send({
          message: `selected Successfully`,
          data: {rawData: data, events: eventData},
        });
      }
    });
  });
});

module.exports = router;
