const jwt = require("jsonwebtoken");
const {JWT_SEC} = require("../../app")
const verifyToken = (req, res, next) => {
  const authHeader = req.headers?.token;
  // console.log("authHeader >>>", authHeader);
  const token = authHeader?.split(" ")?.[1];
  // console.log("token >>>", token);
  if (token) {
    // jwt.verify(token, process.env.JWT_SEC, (err, user) => {
    jwt.verify(token, JWT_SEC, (err, user) => {
      if (err) res.status(403).json({ message: "Token is not valid" });
      req.user = user;
      next();
    });
  } else {
    return res.status(401).json({
      message: "You are not authenticated",
    });
  }
};

const verifyTokenAndAuthorization = (req, res, next) => {
  verifyToken(req, res, () => {
    // console.log("req.user >>",req.user);
    if (req.user?.id === req.params.id || req.user?.userRole) {
      next();
    } else {
      return res.status(403).json({ message: "You are not allowed" });
    }
  });
};

const verifyTokenAndAdmin = (req, res, next) => {
  // console.log("req.headers.token >>>",req.headers.token);
  verifyToken(req, res, () => {
    // console.log("req.user >>>",req.user);
    if (req.user?.userRole) {
      next();
    } else {
      return res.status(403).json({ message: "You are not allowed" });
    }
  });
};

module.exports = {
  verifyToken,
  verifyTokenAndAuthorization,
  verifyTokenAndAdmin
};
