const express = require("express");
const cors = require("cors");
const bodyParser = require("body-parser");
const morgan = require("morgan");
const http = require("http");
const path = require("path");
const jwt = require("jsonwebtoken");
const JWT_SEC = "OEE_PRO";
module.exports = { JWT_SEC };
const db = require("./utils/db");
const { verifyTokenAndAdmin } = require("./routes/middleware/verifyToken");
// DEFINE the path to your scheduled function(s)
const scheduledFunctions = require("./utils/scheduledFunctions/scheduledTest");
// maintain logs
const logger = require("./logger");

const app = express();
app.use(morgan("dev"));
app.use(cors());
// app.use(
//   cors({
//     origin: [
//       "http://localhost:3001",
//       "https://oeef-k.pakistanautomation.com.pk",
//     ],
//   })
// );
app.use(bodyParser.urlencoded({ extended: false, limit: "5mb" }));
app.use(bodyParser.json({ extended: false, limit: "5mb" }));
// app.use(bodyParser.json({ extended: true }));
app.use(express.static("public"));

app.use(
  "/",
  express.static(path.resolve(path.join(__dirname, "../client/build")))
  // express.static(path.resolve(path.join(__dirname, "./build")))
);

// // ADD CALL to execute your function(s)
scheduledFunctions.initScheduledJobs();

// // require routes
// Auth
const createUser = require("./routes/auth/create");
const updateUser = require("./routes/auth/update");
const deleteUser = require("./routes/auth/delete");
const selectUser = require("./routes/auth/select");
const login = require("./routes/auth/login");
// Department Section
const createDept = require("./routes/department/create");
const updateDept = require("./routes/department/update");
const selectDept = require("./routes/department/select");
const deleteDept = require("./routes/department/delete");
//Shift Section
const createShift = require("./routes/shift/create");
const updateshift = require("./routes/shift/update");
const deleteShift = require("./routes/shift/delete");
const selectShift = require("./routes/shift/select");
//orders section
const createOrder = require("./routes/orders/create");
const updateOrder = require("./routes/orders/update");
const deleteOrder = require("./routes/orders/delete");
const selectOrder = require("./routes/orders/select");
//pendingOrders section
const createPendingOrder = require("./routes/holdOrders/create");
const updatePendingOrder = require("./routes/holdOrders/update");
const deletePendingOrder = require("./routes/holdOrders/delete");
const selectPendingOrder = require("./routes/holdOrders/select");
//SKU section
const createSku = require("./routes/sku/create");
const updateSku = require("./routes/sku/update");
const deleteSku = require("./routes/sku/delete");
const selectSku = require("./routes/sku/select");
//SCRAP section
const createScrap = require("./routes/scrap/create");

const selectScrap = require("./routes/scrap/select");
//Lines section
const createLine = require("./routes/lines/create");
const updateLine = require("./routes/lines/update");
const deleteLine = require("./routes/lines/delete");
const selectLine = require("./routes/lines/select");
//Team section
const createTeam = require("./routes/team/create");
const updateTeam = require("./routes/team/update");
const deleteTeam = require("./routes/team/delete");
const selectTeam = require("./routes/team/select");
//distributer section
const createDistributer = require("./routes/distributer/create");
const updateDistributer = require("./routes/distributer/update");
const deleteDistributer = require("./routes/distributer/delete");
const selectDistributer = require("./routes/distributer/select");
//causes section
const createCause = require("./routes/causes/create");
const updateCause = require("./routes/causes/update");
const deleteCause = require("./routes/causes/delete");
const selectCause = require("./routes/causes/select");
//cause code section
const createCauseCode = require("./routes/causeCode/create");
const updateCauseCode = require("./routes/causeCode/update");
const deleteCauseCode = require("./routes/causeCode/delete");
const selectCauseCode = require("./routes/causeCode/select");
//complain section
const createComplain = require("./routes/complain/create");
const updateComplain = require("./routes/complain/update");
const deleteComplain = require("./routes/complain/delete");
const selectComplain = require("./routes/complain/select");
//category section
const createCategory = require("./routes/category/create");
const updateCategory = require("./routes/category/update");
const deleteCategory = require("./routes/category/delete");
const selectCategory = require("./routes/category/select");
//Insert IOT Device data
const createDeviceData = require("./routes/deviceData/create");
const selectDeviceData = require("./routes/deviceData/select");
const sendDeviceInput = require("./routes/deviceData/deviceInput");
//Currunt Status data
const selectCurruntStatus = require("./routes/curruntStatus/selectCurruntStatus");
//Event data
const recordEvent = require("./routes/events/createevents");
const selectEvent = require("./routes/events/select");
//CompleteOrders data
const selectCurruntProductionView = require("./routes/completeOrder/select");
const updateCompleteOrder = require("./routes/completeOrder/update");
//stops section
const createStops = require("./routes/stops/create");
const updateStops = require("./routes/stops/update");
const deleteStops = require("./routes/stops/delete");
const selectStops = require("./routes/stops/select");
//UnplannedTime
const createUnplannedTime = require("./routes/unplannedTime/create");
const updateUnplannedTime = require("./routes/unplannedTime/update");
const deleteUnplannedTime = require("./routes/unplannedTime/delete");
const selectUnplannedTime = require("./routes/unplannedTime/select");

//scrpe reasons Api's
const selectScrapeReasons = require("./routes/globalApis/globalApis");
const selectAgainstScrappoNumber = require("./routes/globalApis/globalApis");

// //stop reasonsTree Api's
// const CreateReasonTree = require("./routes/reasonTree/create");
// const deleteReasonTree = require("./routes/reasonTree/delete");
// const selectReasonTree = require("./routes/reasonTree/select");
// const updateReasonTree = require("./routes/reasonTree/update");

//downtime reasons Api's
const CreateReason = require("./routes/downtimeReason/create");
const deleteReason = require("./routes/downtimeReason/delete");
const selectReason = require("./routes/downtimeReason/select");
const updateReason = require("./routes/downtimeReason/update");

//stop causeTree Api's
const CreateCauseTree = require("./routes/causeTree/create");
const selectCauseTree = require("./routes/causeTree/select");
const updateCauseTree = require("./routes/causeTree/update");
const deleteCauseTree = require("./routes/causeTree/delete");

// attendance APi's
const CreateAttendance = require("./routes/attendance/create");
const updateAttendance = require("./routes/attendance/update");
const selectAttendance = require("./routes/attendance/select");

app.use("/", (req, res, next) => {
  // logger.info('Received GET request at /');
  console.log("------------Request Query--------", req.query);
  console.log("------------Request Body--------", req.body);
  console.log("------------Request Path--------", req.path);
  console.log("------------Request header--------", req.headers);
  console.log("------------Request method--------", req.method);
  const { method, url, headers, body, query, path } = req; // Extract relevant request data
  const { statusCode, statusMessage } = res; // Extract relevant response data
  const { token, ...rest } = headers;
  const getToken = token?.split(" ")?.[1];
  let userData = {};
  if (getToken) {
    jwt.verify(getToken, JWT_SEC, (err, user) => {
      if (err) console.log("Token is not valid >>>", err);
      userData = user;
    });
  }
  // console.log("userData >>>>", userData);

  logger.info(`Request: ${method} ${url}`, {
    headers: rest,
    path,
    body,
    query,
    statusCode,
    statusMessage,
    user: {
      id: userData?.id,
      username: userData?.username,
      email: userData?.email,
    },
  });
  next();
});

// // route apis
//Auth
app.use("/api/auth/", createUser);
app.use("/api/auth/", updateUser);
app.use("/api/auth/", deleteUser);
app.use("/api/auth/", selectUser);
app.use("/api/auth/", login);
// Department section
app.use("/api/department/", createDept);
app.use("/api/department/", updateDept);
app.use("/api/department/", deleteDept);
app.use("/api/department/", selectDept);
//Shift Section
app.use("/api/shift", createShift);
app.use("/api/shift", updateshift);
app.use("/api/shift", deleteShift);
app.use("/api/shift", selectShift);
//SKU section
app.use("/api/sku", createSku);
app.use("/api/sku", updateSku);
app.use("/api/sku", deleteSku);
app.use("/api/sku", selectSku);
//SCRAP section
app.use("/api/scrap", createScrap);

app.use("/api/scrap", selectScrap);
//Line section
app.use("/api/line", createLine);
app.use("/api/line", updateLine);
app.use("/api/line", deleteLine);
app.use("/api/line", selectLine);
//Team section
app.use("/api/team", createTeam);
app.use("/api/team", updateTeam);
app.use("/api/team", deleteTeam);
app.use("/api/team", selectTeam);
//order section
app.use("/api/order", createOrder);
app.use("/api/order", updateOrder);
app.use("/api/order", deleteOrder);
app.use("/api/order", selectOrder);

//reasonTree section
// app.use("/api/reasonTree", CreateReasonTree);
// app.use("/api/reasonTree", updateReasonTree);
// app.use("/api/reasonTree", deleteReasonTree);
// app.use("/api/reasonTree", selectReasonTree);

//DowntimeReason section
app.use("/api/downtimeReason", CreateReason);
app.use("/api/downtimeReason", updateReason);
app.use("/api/downtimeReason", deleteReason);
app.use("/api/downtimeReason", selectReason);

//Hold Order section
app.use("/api/holdOrder", createPendingOrder);
app.use("/api/holdOrder", updatePendingOrder);
app.use("/api/holdOrder", deletePendingOrder);
app.use("/api/holdOrder", selectPendingOrder);
//distributer section
app.use("/api/distributer", createDistributer);
app.use("/api/distributer", updateDistributer);
app.use("/api/distributer", deleteDistributer);
app.use("/api/distributer", selectDistributer);
//complain section
app.use("/api/complain", createComplain);
app.use("/api/complain", updateComplain);
app.use("/api/complain", deleteComplain);
app.use("/api/complain", selectComplain);
//cause section
app.use("/api/cause", createCause);
app.use("/api/cause", updateCause);
app.use("/api/cause", deleteCause);
app.use("/api/cause", selectCause);

//causeTree section
app.use("/api/causeTree", CreateCauseTree);
app.use("/api/causeTree", updateCauseTree);
app.use("/api/causeTree", deleteCauseTree);
app.use("/api/causeTree", selectCauseTree);

//cause section
app.use("/api/causeCode", createCauseCode);
app.use("/api/causeCode", updateCauseCode);
app.use("/api/causeCode", deleteCauseCode);
app.use("/api/causeCode", selectCauseCode);
//category section
app.use("/api/category/", createCategory);
app.use("/api/category/", updateCategory);
app.use("/api/category/", deleteCategory);
app.use("/api/category/", selectCategory);
//device data section
app.use("/api/deviceData/", createDeviceData);
app.use("/api/deviceData", selectDeviceData);
app.use("/api/deviceData", sendDeviceInput);
//Currunt status section
app.use("/api/curruntStatus/", selectCurruntStatus);
//Event section
app.use("/api/events/", recordEvent);
app.use("/api/events/", selectEvent);

//Complete Orders section
app.use("/api/completeOrders/", selectCurruntProductionView);
app.use("/api/completeOrders/", updateCompleteOrder);
//stops section
app.use("/api/stops/", createStops);
app.use("/api/stops/", updateStops);
app.use("/api/stops/", deleteStops);
app.use("/api/stops/", selectStops);
//UnplannedTime section
app.use("/api/UnplannedTime/", createUnplannedTime);
app.use("/api/UnplannedTime/", updateUnplannedTime);
app.use("/api/UnplannedTime/", deleteUnplannedTime);
app.use("/api/UnplannedTime/", selectUnplannedTime);

////scrape ResonsApis
app.use("/api/scrapeReasons/", selectScrapeReasons);
app.use("/api/scrapeAgaistpoNumber/", selectAgainstScrappoNumber);

//Attendance API's
app.use("/api/attendance/", CreateAttendance);
app.use("/api/attendance/", updateAttendance);
app.use("/api/attendance/", selectAttendance);

app.get("/checkServer", function (req, res, next) {
  res.send("Server is Runing");
});

app.get("/get", verifyTokenAndAdmin, (req, res) => {
  db.getConnection((err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      throw err;
    }
    const query = `select * from Users order by id desc`;
    connection.query(query, (err, rows) => {
      connection.release(); // return the connection to pool
      if (err)
        res.status(401).json({
          message: "Some error in User selection",
          results: "Failed",
          data: [],
        });
      res.status(201).json({
        message: "Fetch Data Successfully",
        results: "Success",
        data: rows,
      });
    });
  });
});

process.on("unhandledRejection", (error) => {
  console.error("Uncaught Promise Rejection:", error.stack);
  logger.error("Uncaught Promise Rejection:", error); // Log to file
  res.status(500).send({ message: "Something went wrong" });
});
const errorHandler = (err, req, res, next) => {
  console.error("Error caught in global error handler:", err.message);
  const { method, url } = req;

  console.error(err.stack);
  logger.error(`Request: ${method} ${url}`, {
    errorMessage: err.message,
    errorStack: err.stack,
    error: err,
  });
  logger.info(`Request: ${method} ${url}`, {
    errorMessage: err.message,
    errorStack: err.stack,
    error: err,
  });
  res.status(500).send({ message: "Something went wrong" });
  next(err);
};
app.use(errorHandler);

const server = http.createServer(app);
// server.listen("5000", "192.168.1.122", () => {
//   console.info(`server running on port 5000`);
// });
const PORT = process.env.PORT || 5000;
server.listen(PORT, () => {
  console.log(`Server is running on: http://localhost:${PORT}`);
});
