const express = require("express");
const router = express.Router();
const db = require("../../utils/db");
const moment = require("moment");
const { verifyToken } = require("../middleware/verifyToken");
const { isUndefined } = require("lodash");


// router.post("/punchOut", verifyToken, async (req, res) => {
router.post("/punchOut", async (req, res) => {

  const timestamp = moment
    .utc(Date())
    .add(5,'hours')                   // Adjust Server Time
    .format("MM/DD/YYYY HH:mm:ss");
  
  const query = {
    getShiftQuery: `
      SELECT * FROM Shift
        WHERE (
          TIME(STR_TO_DATE(startTime, '%H:%m:%s')) <= '${moment
            .utc(timestamp)
            .format("HH:mm:ss")}'
          AND TIME(STR_TO_DATE(endTime, '%H:%m:%s')) > '${moment
            .utc(timestamp)
            .format("HH:mm:ss")}'
        )
        OR (
          TIME(STR_TO_DATE(startTime, '%H:%m:%s')) > TIME(STR_TO_DATE(endTime, '%H:%m:%s')) 
          AND (
              TIME('${moment
                .utc(timestamp)
                .format("HH:mm:ss")}') >= TIME(STR_TO_DATE(startTime, '%H:%m:%s'))
              OR TIME('${moment
                .utc(timestamp)
                .format("HH:mm:ss")}') < TIME(STR_TO_DATE(endTime, '%H:%m:%s'))
            )
        );`,
    searchAttendanceQuery: ``,
    punchOutQuery: "",
  };

  const userId = req.body?.userId;
  const deviceName = req.body?.deviceName;

  console.log("req.body >>> ", req.body);
  console.log("userId >>> ", userId);
  console.log("deviceName >>> ", deviceName);

  if(isUndefined(userId) || isUndefined(deviceName)){
    res.status(404).send({
      message: ("Required Data is Missing"),
    });
  }
  else{
    await db.getConnection(async (err, connection) => {
      if (err) {
        console.log("database not connected error: >>>", err);
        throw err;
      }

      await connection.query(query.getShiftQuery, (err, shiftDate) => {
        if (err) {
          console.log("error from GetShift  >>>", err);
          connection.release();
          res.status(404).send({
            message: ("error from GetShift  >>>", err),
          });
        } else {
          const shift = shiftDate[0]?.shiftName;
          //   query.searchAttendanceQuery = `
          //   SELECT * FROM attendance
          //   where
          //       userId = ${userId} AND
          //       punchOut IS NULL
          //       ORDER BY id DESC`;
          query.searchAttendanceQuery = `
          SELECT *
          FROM attendance
          WHERE 
              userId = ${userId} AND deviceName = '${deviceName}' AND
              punchOut IS NULL
          `;
          // `
          // SELECT *
          // FROM attendance
          // WHERE 
          //     userId = ${userId} AND deviceName = '${deviceName}' AND
          //     punchOut IS NULL AND 
          //     (
          //         date = '${dateOut}' OR 
          //         date = '${moment
          //           .utc(dateOut)
          //           .subtract(1, "days")
          //           .format("MM/DD/YYYY ")}'
          //     )
          // `;

          connection.query(query.searchAttendanceQuery, (err, attendanceData) => {
            if (err) {
              console.log("error from Search Attendance  >>>", err);
              connection.release();
              res.status(404).send({
                message: ("error from Search Attendance  >>>", err),
              });
            } 
            else {
              console.log("Search Query >>> ", query.searchAttendanceQuery);
              console.log("Result >>> ", attendanceData);
              console.log("timestamp >>> ", timestamp);
              if (attendanceData.length > 0) {
                let duration =
                  (Date.parse(moment(timestamp)) -
                    Date.parse(moment(attendanceData[0]?.punchIn))) /
                  1000 /
                  60;
                console.log("duration >>> ", duration);
                query.punchOutQuery = `UPDATE attendance SET punchOut='${timestamp}', duration='${duration}', deviceName = '${deviceName}' WHERE id='${attendanceData[0]?.id}'`;

                connection.query(query.punchOutQuery, (err, punchOutData) => {
                    connection.release();
                    if (err) {
                      console.log("error from Search Attendance  >>>", err);
                      res.status(404).send({
                        message: ("error from Search Attendance  >>>", err),
                      });
                    } else {
                      res.status(200).send({
                        message: "Punch Out Successfully",
                        data: punchOutData,
                      });
                    }
                  }
                );
              } else {
                  connection.release();
                  res.status(404).send({
                  message: "Entry not Found Please PunchIn First",
                  });
              }
            }
          });
        }
      });
    });
  }
});

module.exports = router;
