const express = require("express");
const router = express.Router();
const db = require("../../utils/db");
const { verifyTokenAndAdmin } = require("../middleware/verifyToken");

router.get("/getUsers", verifyTokenAndAdmin, (req, res) => {
  // router.get("/getUsers", (req, res) => {
  console.log("req.body >>>", req.body);
  console.log("req.query >>>", req.query);
  // const id = req.body.id;
  const id = req.query.id;

  db.getConnection((err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      throw err;
    }

    // const query = id
    //   ? `SELECT * FROM Users WHERE id=${id}`
    //   : `SELECT * FROM Users`;
    // const query = id
    // ? `SELECT Users.*, LineDetails.* FROM Users INNER JOIN LineDetails ON Users.lineId = LineDetails.id WHERE Users.id=${id}`
    // : `SELECT Users.*, LineDetails.* FROM Users INNER JOIN LineDetails ON Users.lineId = LineDetails.id`;   
    const query = id
    ? `SELECT Users.id, Users.username, Users.email, Users.userRole, Users.avatar, Users.lineId, LineDetails.deviceName FROM Users LEFT JOIN LineDetails ON Users.lineId = LineDetails.id WHERE Users.id=${id}`
    : `SELECT Users.id, Users.username, Users.email, Users.userRole, Users.avatar, Users.lineId, LineDetails.deviceName FROM Users LEFT JOIN LineDetails ON Users.lineId = LineDetails.id`;
    
    connection.query(query, (err, data) => {
      connection.release();
      if (err) {
        console.log("error from select user ==>", err);
        if (err.code === "ENOTFOUND") {
          res.status(404).json({
            message: "Internet Connection Failed",
          });
        }
        res.status(500).json({
          message: "Error From Server",
        });
      } else {
        res.status(200).json({
          message: "selectd Successfully",
          data: data,
        });
      }
    });
  });
});

module.exports = router;
