const express = require("express");
const router = express.Router();
const db = require("../../utils/db");
const moment = require("moment");
const { isUndefined } = require("lodash");
const apiResponse = {
  message: [],
  attendance:'',
  newDeviceData: '',
  deviceData: '',
  currentShift: '',
  stops: '',
  completedOrders: '',
  newcompletedOrders: '',
}

function getConnection() {
  return new Promise((resolve, reject) => {
    db.getConnection((err, connection) => {
      if (err) {
        reject(err);
        return;
      }

      resolve(connection);
    });
  });
}

async function performQuery(sql, params) {
  const connection = await getConnection();

  try {
    return new Promise((resolve, reject) => {
      connection.query(sql, params, (error, results) => {
        if (error) {
          reject(error);
          return;
        }
        resolve(results);
      });
    });
  } finally {
    connection.release();
  }
}


router.post("/insertData", async (req, res) => {

  const deviceData = {
    Name: req.body.deviceId,
    timestamp: req.body.timestamp || new Date(),
    status: req.body.d1,
    count: req.body.v2,
    speed: req.body.machineSpeed,
    activePO: req.body.runningPO || "",
    SKU: req.body.SKU || "",
    SKUTarget: req.body.SKUTarget || "",
    orderId: req.body.orderId || "",
    shift: req.body.currentShift,
    stopId: Number(req.body.stopId) 
  };

  console.log("deviceData >>> ",deviceData);
  // var lastPoNumber = {
  //   poNumber: ""
  // };

  await db.getConnection(async (err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      throw err;
    }

    const query = 
    `INSERT INTO DeviceData 
      (
        deviceName,deviceStatus,productCount,poNumber,
        skuName,skuTarget,orderId,timestamp,
        machineSpeed,qtyInKg, stopId
      )
      VALUES
      ("${deviceData.Name}", "${deviceData.status}", "${deviceData.count}", "${deviceData.activePO}", 
      "${deviceData.SKU}", "${deviceData.SKUTarget}", "${deviceData.orderId}", "${deviceData.timestamp}", 
      "${deviceData.speed}", "${deviceData.qtyinKg}", "${deviceData.stopId}")`;

    // console.log("Query>>> ", query);
    // const query = `INSERT INTO DeviceData (deviceName,deviceStatus,productCount,timestamp,scrap,causeOne,machineSpeed) VALUES ("${deviceName}",${deviceStatus},${productCount},"${timestamp}",${scrap},"${causeOne}","${machineSpeed}")`;
    await connection.query(query, (err, data) => {
      connection.release();
      if (err) {
        console.log("error from Insert Data in DeviceData >>>", err);
      } else {
        // console.log("lastPoNumber >>>",lastPoNumber);
        res.status(200).send({
          message: "Success",
        });
      }
    });
  });
});



router.post("/insertDataNew1", async (req, res) => {
  const deviceData = {
    Name: req.body.deviceId,
    timestamp: req.body.timestamp || new Date(),
    status: Number(req.body.d1),
    count: req.body.v2,
    qtyinKg: req.body.v3,
    speed: req.body.machineSpeed,
    activePO: req.body.runningPO || "",
    SKU: req.body.SKU || "",
    SKUTarget: req.body.SKUTarget || "",
    orderId: req.body.orderId || "",
    shift: req.body.currentShift,
    stopId: Number(req.body.stopId) 
  };

  const timestamp = moment.utc(deviceData.timestamp, "MM/DD/YYYY HH:mm:ss");

  // Check if time is between 00:00:00 and 06:59:59
  if (timestamp.hour() < 7) {
      // Subtract one day
      timestamp.subtract(1, 'days');
  }

  console.log("deviceData >>> ", deviceData);
  apiResponse.deviceData = deviceData

  // Open Connection
  await db.getConnection(async (err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      throw err;
    }
    else{
      // If Connection Seccussfull
      const query = 
        `INSERT INTO DeviceData 
          (
            deviceName,deviceStatus,productCount,poNumber,
            skuName,skuTarget,orderId,timestamp,
            machineSpeed,qtyInKg
          )
          VALUES
          ("${deviceData.Name}", "${deviceData.status}", "${deviceData.count}", "${deviceData.activePO}", 
          "${deviceData.SKU}", "${deviceData.SKUTarget}", "${deviceData.orderId}", "${deviceData.timestamp}", 
          "${deviceData.speed}", "${deviceData.qtyinKg}")`;

      // Insert Device Data
      await connection.query(query, (err, insertedDeviceData) => {
        if (err) {
          console.log("error from Query insertedDeviceData >>>", err);
        } else {
          apiResponse.newDeviceData = insertedDeviceData
          console.log("insertedDeviceData >>> ",insertedDeviceData);
          // Select Shift on Basis of Timestamp
          const selectShiftQuery = `
          SELECT *
          FROM Shift
          WHERE (
                  TIME(STR_TO_DATE(startTime, '%H:%m:%s')) <= '${moment.utc(deviceData.timestamp).format("HH:mm:ss")}'
                  AND TIME(STR_TO_DATE(endTime, '%H:%m:%s')) > '${moment.utc(deviceData.timestamp).format("HH:mm:ss")}'
                )
                OR (
                  TIME(STR_TO_DATE(startTime, '%H:%m:%s')) > TIME(STR_TO_DATE(endTime, '%H:%m:%s')) 
                  AND (
                      TIME('${moment.utc(deviceData.timestamp).format("HH:mm:ss")}') >= TIME(STR_TO_DATE(startTime, '%H:%m:%s'))
                      OR TIME('${moment.utc(deviceData.timestamp).format("HH:mm:ss")}') < TIME(STR_TO_DATE(endTime, '%H:%m:%s'))
                    )
                );`;
          // console.log("selectShiftQuery >>> ", selectShiftQuery);
          connection.query(selectShiftQuery, (err, shiftData) => {
            if (err) {
              console.log("Error from Select Shift Query >>>", err);
              apiResponse.message.push("Error from Select Shift Query >>>", err);
              res.send({
                message: "Error from Select Shift Query",
                data: apiResponse
              });
            } else {
              apiResponse.currentShift = shiftData
              console.log("shiftData >>> ",shiftData);

              // Select Complete Order
              const selectCompleteOrdersQuery = `
              SELECT * FROM CompleteOrders where (
                deviceName = '${deviceData.Name}' AND
                poNumber = '${deviceData.activePO}' AND
                skuName = '${deviceData.SKU}' AND
                shiftName = '${shiftData[0].shiftName}' AND
                orderId = '${deviceData.orderId}' AND
                DATE(STR_TO_DATE(plannedStart,'%m/%d/%Y')) = '${moment.utc(timestamp).format("YYYY-MM-DD")}'
              )`;
              // console.log("selectCompleteOrdersQuery >>> ", selectCompleteOrdersQuery);
              connection.query(selectCompleteOrdersQuery, (err, completeOrderData) => {
                if (err) {
                  console.log("error from Query >>>", err);
                  apiResponse.message.push("Error from Select Complete Order Query >>>", err);
                  res.send({
                    message: "Error from Select Complete Order Query",
                    data: apiResponse
                  });
                } else {
                  apiResponse.completedOrders = completeOrderData
                  console.log("completeOrderData >>> ", completeOrderData);
                  // Select Existing Stop Based on Status
                  const selectStopQuery = `
                  SELECT * FROM Stops where (
                    status = 'In Progress' AND
                    shiftName = '${shiftData[0].shiftName}' AND
                    orderId = '${deviceData.orderId}' AND
                    DATE(STR_TO_DATE(orderStart,'%m/%d/%Y')) = '${moment.utc(timestamp).format("YYYY-MM-DD")}'

                  )`;
                  // console.log("selectStopQuery >>> ", selectStopQuery);
                  connection.query(selectStopQuery, (err, existingStopData) => {
                    if (err) {
                      console.log("error from Select Stop Query >>>", err);
                      apiResponse.message.push("Error from Select Stop Query >>>", err);
                      res.send({
                        message: "Error from Select Stop Query",
                        data: apiResponse
                      });
                    } else {
                      apiResponse.stops = existingStopData
                      console.log("existingStopData >>> ",existingStopData);


                      // Update / Create Complete Order Record
                      if(completeOrderData?.length > 0){
                        console.log("Update Complete Order");
                        // Calculate Total Order Time
                        let totalOrderTime = (
                          moment.utc(deviceData.timestamp) - 
                          moment.utc(completeOrderData[0].plannedStart) 
                        )/1000

                        // Initiallize Variables for Up and Down Time
                        let downTime = 0;
                        let upTime = 0;

                        // Get Down Time of all stops for this order
                        const getdownTimeQuery = `
                          SELECT downTime FROM Stops WHERE 
                          deviceName="${deviceData.Name}" AND 
                          orderStart="${completeOrderData[0].plannedStart}" `
                        
                        connection.query(getdownTimeQuery, (err, downtimeData) => {
                          if (err) {
                            console.log("error from Select downTime Query >>>", err);
                            apiResponse.message.push("Error from Select downTime Query >>>", err);
                            res.send({
                              message: "Error from Select downTime Query",
                              data: apiResponse
                            });
                          } 
                          else {
                            downtimeData.map((data)=>{
                              downTime += Number(data.downTime);
                            });
                            upTime = totalOrderTime - downTime;

                            // Update Complete Order
                            apiResponse.message.push("Updating Complete Order Query ");
                            const updateCompleteOrderQuery = `
                              UPDATE CompleteOrders SET 
                              productCount='${deviceData.count}',
                              deviceStatus='${deviceData.status}',
                              plannedEnd='${moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss")}',
                              upTime='${upTime}',
                              downTime='${downTime}',
                              qtyInKg='${deviceData.qtyinKg}',
                              timestamp='${moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss")}' 
                              WHERE 
                              id= '${completeOrderData[0].id}'
                            `

                            completeOrderData[0].productCount = deviceData.count
                            completeOrderData[0].deviceStatus = deviceData.status
                            completeOrderData[0].plannedEnd = moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss")
                            completeOrderData[0].qtyInKg = deviceData.qtyinKg
                            completeOrderData[0].timestamp = moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss")

                            apiResponse.message.push("completeOrderData Changed");
                            apiResponse.completedOrders = completeOrderData
                            
                            connection.query(updateCompleteOrderQuery, (err, newCompleteOrdersData) => {
                              if (err) {
                                console.log("error from Update Complete Order Query >>>", err);
                                apiResponse.message.push("Error from Update Complete Order Query >>>", err);
                                res.send({
                                  message: "Error from Update Complete Order Query",
                                  data: apiResponse
                                });
                              } else {
                                apiResponse.message.push("Updating Successful");
                                apiResponse.newCompletedOrders = newCompleteOrdersData
                              }
                            });
                          }
                        });
                      }
                      else{
                        console.log("Create Complete Order");
                        // Insert Complete Order Record
                        apiResponse.message.push("Insert Complete Order");
                        const InsertCompleteOrderQuery = `
                          INSERT INTO CompleteOrders (
                            deviceName,  productCount,  deviceStatus,  
                            poNumber,  skuName,  skuTarget,  
                            shiftName,  plannedStart,  plannedEnd,  
                            orderCompletionStatus,  scrap,  orderId,  
                            shiftStartTime,  shiftEndTime,  qtyInKg,  
                            timestamp
                          ) 
                          VALUES (
                            '${deviceData.Name}','${deviceData.count}','${deviceData.status}',
                            '${deviceData.activePO}','${deviceData.SKU}','${deviceData.SKUTarget}',
                            '${shiftData[0].shiftName}','${moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss")}','${moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss")}',
                            '1','0','${deviceData.orderId}',
                            '${shiftData[0].startTime}','${shiftData[0].endTime}','${deviceData.qtyinKg}',
                            '${moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss")}'
                          )
                        `
                        completeOrderData.push(
                          {
                            plannedStart: moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss"),
                            plannedEnd: moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss"),
                          }
                        )
                        
                        apiResponse.message.push("completeOrderData Changed");
                        apiResponse.completedOrders = completeOrderData

                        connection.query(InsertCompleteOrderQuery, (err, newCompleteOrdersData) => {
                          if (err) {
                            console.log("error from Insert Complete Order Query >>>", err);
                            apiResponse.message.push("Error from Insert Complete Order Query >>>", err);
                            res.send({
                              message: "Error from Insert Complete Order Query",
                              data: apiResponse
                            });
                          } else {
                            apiResponse.message.push("Insert Successfull");
                            apiResponse.newCompletedOrders = newCompleteOrdersData
                          }
                        });
                      }

                      console.log(" deviceData.status===0 >>> ", deviceData.status==="0");
                      // Update / Create Stop Record
                      if(existingStopData?.length > 0){
                        let downtime = (
                          moment.utc(deviceData.timestamp) - 
                          moment.utc(existingStopData[0].startTime) 
                        )/1000

                        apiResponse.message.push("Updating Stop Query ");
                        const updateStopQuery = `
                          UPDATE Stops SET 
                          endTime='${moment.utc(deviceData.timestamp).toISOString()}',
                          orderEnd='${completeOrderData[0].plannedEnd}',
                          downTime='${downtime}',
                          Status='${deviceData.status===1?"Completed":"In Progress"}' 
                          WHERE 
                          id= '${existingStopData[0].id}'
                        `
                        connection.query(updateStopQuery, (err, newStopsData) => {
                          if (err) {
                            console.log("error from Update Stops Query >>>", err);
                            apiResponse.message.push("Error from Update Stops Query >>>", err);
                            res.send({
                              message: "Error from Update Stops Query",
                              data: apiResponse
                            });
                          } else {
                            apiResponse.message.push("Updating Successful");
                            apiResponse.newStops = newStopsData
                          }
                        });
                      }
                      else if(deviceData.status===0){
                        console.log("Insert New Stop");
                        apiResponse.message.push("Insert New Stop");
                        const InsertStopQuery = `
                        INSERT INTO Stops (
                          startTime, endTime, downTime, 
                          orderStart, orderEnd, categoryName, 
                          childDeviceName, deviceName, shiftName, 
                          shiftStartTime, shiftEndTime, deviceDataId, 
                          orderId, mainStopId, skuName, 
                          Status
                        ) 
                        VALUES (
                          '${moment.utc(deviceData.timestamp).toISOString()}','${moment.utc(deviceData.timestamp).toISOString()}','0',
                          '${completeOrderData[0].plannedStart}','${completeOrderData[0].plannedEnd}','Unplanned',
                          '${deviceData.Name}','${deviceData.Name}','${shiftData[0].shiftName}',
                          '${shiftData[0].startTime}','${shiftData[0].endTime}','${apiResponse.newDeviceData.insertId}',
                          '${deviceData.orderId}','0','${deviceData.SKU}',
                          'In Progress'
                        )
                        `
                        connection.query(InsertStopQuery, (err, newCompleteOrdersData) => {
                          if (err) {
                            console.log("error from Insert Complete Order Query >>>", err);
                            apiResponse.message.push("Error from Insert Complete Order Query >>>", err);
                            res.send({
                              message: "Error from Insert Complete Order Query",
                              data: apiResponse
                            });
                          } else {
                            apiResponse.message.push("Insert Successfull");
                            apiResponse.newCompletedOrders = newCompleteOrdersData
                          }
                        });
                      }

                      connection.release()
                      res.status(200).send({
                        message: "Success",
                        // data: apiResponse
                      });
                    }
                  });
                }
              }); 
            }
          });
        }
      });
    }
  });
});


// router.post("/insertDataNew", async (req, res) => {
//   const deviceData = {
//     Name: req.body.deviceId,
//     timestamp: req.body.timestamp || new Date(),
//     status: Number(req.body.d1),
//     count: Number(req.body.v2),
//     qtyinKg: Number(req.body.v3),
//     speed: Number(req.body.machineSpeed),
//     activePO: req.body.runningPO || "",
//     SKU: req.body.SKU || "",
//     SKUTarget: Number(req.body.SKUTarget) || 500,
//     orderId: Number(req.body.orderId) || 0,
//     shift: req.body.currentShift,
//   };

//   const timestamp = moment.utc(deviceData.timestamp, "MM/DD/YYYY HH:mm:ss");

//   // Check if time is between 00:00:00 and 06:59:59
//   if (timestamp.hour() < 7) {
//       // Subtract one day
//       timestamp.subtract(1, 'days');
//   }

//   console.log("deviceData >>> ", deviceData);
//   apiResponse.deviceData = deviceData

//   const selectShiftQuery = `
//   SELECT *
//   FROM Shift
//   WHERE (
//           TIME(STR_TO_DATE(startTime, '%H:%m:%s')) <= ?
//           AND TIME(STR_TO_DATE(endTime, '%H:%m:%s')) > ?
//         )
//         OR (
//           TIME(STR_TO_DATE(startTime, '%H:%m:%s')) > TIME(STR_TO_DATE(endTime, '%H:%m:%s')) 
//           AND (
//               TIME(?) >= TIME(STR_TO_DATE(startTime, '%H:%m:%s'))
//               OR TIME(?) < TIME(STR_TO_DATE(endTime, '%H:%m:%s'))
//             )
//         )  
//   `;
//   const shiftQueryParams = [moment.utc(deviceData.timestamp).format("HH:mm:ss"),moment.utc(deviceData.timestamp).format("HH:mm:ss"),moment.utc(deviceData.timestamp).format("HH:mm:ss"),moment.utc(deviceData.timestamp).format("HH:mm:ss")];
  
//   // Perform the database query
  
//   const selectAttendance=`
//   SELECT * FROM attendance WHERE
//   deviceName=? AND 
//   STR_TO_DATE(punchIn, '%m/%d/%Y %H:%i:%s') <= STR_TO_DATE(?, '%m/%d/%Y %H:%i:%s') AND 
//   (
//     STR_TO_DATE(punchOut, '%m/%d/%Y %H:%i:%s') >= STR_TO_DATE(?, '%m/%d/%Y %H:%i:%s') OR 
//     punchOut IS NULL
//   ) 
//   `
//   const attendanceQueryParams = [deviceData.Name, deviceData.timestamp, deviceData.timestamp]
  
//   const shiftData = await performQuery(selectShiftQuery, shiftQueryParams);
//   console.log("shiftData >>> ",shiftData);

//   const attendanceData = await performQuery(selectAttendance, attendanceQueryParams);
//   console.log("attendanceData >>> ",attendanceData);
  
//   const query = {
//     insertDeviceData:`
//     INSERT INTO DeviceData (
//       deviceName,deviceStatus,productCount,poNumber, skuName,
//       skuTarget,orderId,timestamp, machineSpeed,qtyInKg
//     )
//     VALUES (
//       ?, ?, ?, ?, ?, 
//       ?, ?, ?, ?, ?
//     )`,

//     deviceDataParams: [
//       deviceData.Name, deviceData.status, deviceData.count, deviceData.activePO, deviceData.SKU, 
//       deviceData.SKUTarget, deviceData.orderId, deviceData.timestamp, deviceData.speed, deviceData.qtyinKg
//     ],
    
//     selectCompleteOrders: `
//     SELECT * FROM CompleteOrders where (
//       deviceName = ? AND
//       poNumber = ? AND
//       skuName = ? AND
//       shiftName = ? AND
//       orderId = ? AND
//       (DATE(STR_TO_DATE(plannedStart,'%m/%d/%Y')) = ? OR DATE(STR_TO_DATE(plannedStart,'%m/%d/%Y')) = ?)
//     ) ORDER BY id DESC`,

//     completeOrderParams:[deviceData.Name, deviceData.activePO, deviceData.SKU, shiftData[0]?.shiftName, deviceData.orderId, moment.utc(timestamp).format("YYYY-MM-DD"), deviceData.timestamp],

//     selectStop:`
//     SELECT * FROM Stops where (
//       status = 'In Progress' AND
//       shiftName = ? AND
//       orderId = ? AND
//       (DATE(STR_TO_DATE(orderStart,'%m/%d/%Y')) = ? OR DATE(STR_TO_DATE(orderStart,'%m/%d/%Y')) = ?)
//     ) ORDER BY id DESC`,
//     stopParams:[shiftData[0]?.shiftName, deviceData.orderId, moment.utc(timestamp).format("YYYY-MM-DD"), deviceData.timestamp],

//     selectEvents:`SELECT * FROM events WHERE Status = "In Progress"`,

//   }

//   const insertedDeviceData = await performQuery(query.insertDeviceData, query.deviceDataParams);
//   console.log("insertedDeviceData >>> ",insertedDeviceData);

//   const completeOrderData = await performQuery(query.selectCompleteOrders, query.completeOrderParams);
//   console.log("completeOrderData >>> ",completeOrderData);
  
//   const existingStopData = await performQuery(query.selectStop, query.stopParams);
//   console.log("existingStopData >>> ",existingStopData);
  
//   const existingEventData = await performQuery(query.selectEvents, []);
//   console.log("eventData >>> ",existingEventData);
  
//   apiResponse.currentShift = shiftData
//   apiResponse.attendance = attendanceData
//   apiResponse.newDeviceData = insertedDeviceData
//   apiResponse.completedOrders = completeOrderData
//   apiResponse.stops = existingStopData
//   apiResponse.event = existingEventData

//   // Update / Create Complete Order Record
//   if(completeOrderData?.length > 0){
//     console.log("Update Complete Order");
//     // Update Complete Order
//     apiResponse.message.push("Updating Complete Order Query ");
//     const updateCompleteOrderQuery = `
//       UPDATE CompleteOrders SET 
//       productCount=?,
//       deviceStatus=?,
//       plannedEnd=?,
//       qtyInKg=?,
//       timestamp=? 
//       WHERE 
//       id= ?
//     `
//     const updateCompleteOrderParams = [deviceData.count, deviceData.status, moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss"), deviceData.qtyinKg, moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss"), completeOrderData[0].id]

//     completeOrderData[0].productCount = deviceData.count
//     completeOrderData[0].deviceStatus = deviceData.status
//     completeOrderData[0].plannedEnd = moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss")
//     completeOrderData[0].qtyInKg = deviceData.qtyinKg
//     completeOrderData[0].timestamp = moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss")
    
//     const newCompleteOrdersData = await performQuery(updateCompleteOrderQuery, updateCompleteOrderParams);
//     apiResponse.message.push("Updating Complete Order Successful, ID: ", completeOrderData[0].id);
//     apiResponse.newCompletedOrders = newCompleteOrdersData
//   }
//   else{
//     console.log("Create Complete Order");
//     // Insert Complete Order Record
//     apiResponse.message.push("Insert Complete Order");
//     const InsertCompleteOrderQuery = `
//       INSERT INTO CompleteOrders (
//         deviceName,  productCount,  deviceStatus, poNumber,  
//         skuName,  skuTarget, shiftName,  plannedStart,  
//         plannedEnd, orderCompletionStatus, orderId, shiftStartTime,  
//         shiftEndTime,  qtyInKg, timestamp
//       ) 
//       VALUES (
//         ?,?,?,?,
//         ?,?,?,?,
//         ?,?,?,?,
//         ?,?,?
//       )
//     `
//     const insertCompleteOrderParams = [
//       deviceData.Name, deviceData.count, deviceData.status, deviceData.activePO, 
//       deviceData.SKU, deviceData.SKUTarget, shiftData[0]?.shiftName, moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss"), 
//       moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss"), '1', deviceData.orderId, shiftData[0]?.startTime, 
//       shiftData[0]?.endTime, deviceData.qtyinKg, moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss")]

//     completeOrderData.push({
//       plannedStart: moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss"),
//       plannedEnd: moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss"),
//     })
//     const newCompleteOrdersData = await performQuery(InsertCompleteOrderQuery, insertCompleteOrderParams);  
//     console.log("Complete Order Insert Successfull ID: ", newCompleteOrdersData.insertId);
//     apiResponse.message.push("Complete Order Insert Successfull ID: ", newCompleteOrdersData.insertId);
//     apiResponse.newCompletedOrders = newCompleteOrdersData
//   }

//   console.log(" deviceData.status===0 >>> ", deviceData.status==="0");
//   // Update / Create Stop Record
//   if(existingStopData?.length > 0){
//     let downtime = (
//       moment.utc(deviceData.timestamp) - 
//       moment.utc(existingStopData[0].startTime) 
//     )/1000

//     apiResponse.message.push("Updating Stop Query ");
//     const updateStopQuery = `
//       UPDATE Stops SET 
//       endTime=?,
//       orderEnd=?,
//       downTime=?,
//       Status=? 
//       WHERE 
//       id= ?
//     `
//     const updateStopParams = [
//       moment.utc(deviceData.timestamp).toISOString(), completeOrderData[0].plannedEnd, 
//       downtime, deviceData.status===1?"Completed":"In Progress", existingStopData[0].id]
    
//     const updatedStopData = await performQuery(updateStopQuery, updateStopParams);  
//     apiResponse.message.push("Stop Updated Successful");
//     apiResponse.updatedStopData = updatedStopData

//   }
//   else if(deviceData.status===0){
//     console.log("Insert New Stop");
//     apiResponse.message.push("Insert New Stop");
//     const InsertStopQuery = `
//     INSERT INTO Stops (
//       startTime, endTime, downTime, 
//       orderStart, orderEnd, categoryName, subCategoryName,
//       childDeviceName, deviceName, shiftName, 
//       shiftStartTime, shiftEndTime, deviceDataId, 
//       orderId, mainStopId, skuName, 
//       Status
//     ) 
//     VALUES (
//       ?,?,?,?,?,?,
//       ?,?,?,?,?,?,
//       ?,?,?,?,?
//     )
//     `
//     const InsertStopParams = [
//       moment.utc(deviceData.timestamp).toISOString(), moment.utc(deviceData.timestamp).toISOString(), '0',
//       completeOrderData[0]?.plannedStart, completeOrderData[0]?.plannedEnd, 0 , 'Unreported',
//       deviceData.Name, deviceData.Name, shiftData[0]?.shiftName,
//       shiftData[0]?.startTime, shiftData[0]?.endTime, insertedDeviceData.insertId,
//       deviceData.orderId,'0',deviceData.SKU,
//       'In Progress'
//     ]
    
//     const newStopData = await performQuery(InsertStopQuery, InsertStopParams);  
//     apiResponse.message.push("Stop Inserted Successfull");
//     apiResponse.newStopData = newStopData
//   }

//   const deviceCondition = deviceData.status==1?"Running":"Stop"

//   const eventDate = (existingEventData?.length>0)?moment(existingEventData[0].startTime).format("YYYY-MM-DD"):''
//   const currentDate = moment(timestamp).format("YYYY-MM-DD")
//   // console.log('eventDate > ', eventDate);
//   // console.log('currentDate > ', currentDate);

//   let cond1 = existingEventData?.length === 0
//   let cond2 = existingEventData[0]?.eventName !== deviceCondition
//   let cond3 = existingEventData[0]?.userId !== (attendanceData.length>0? attendanceData[0]?.userId:existingEventData[0]?.userId)
//   let cond4 = existingEventData[0]?.orderId !== deviceData.orderId
//   let cond5 = existingEventData[0]?.shift !== shiftData[0]?.shiftName
//   let cond6 = currentDate > eventDate

//   console.log("cond1 >", cond1);
//   console.log("cond2 >", cond2);
//   console.log("cond3 >", cond3);
//   console.log("cond4 >", cond4);
//   console.log("cond5 >", cond5);
//   console.log("cond6 >", cond6);

//   const newEventCondition = 
//   cond1 || (cond2 || cond3 || cond4 || cond5 || cond6)


//   console.log("newEventCondition >>>",newEventCondition);
  
//   if(newEventCondition){
//     //Manage Events
//     const insertEventQuery = `
//     INSERT INTO events (
//       deviceName, eventName, startTime, 
//       endTime, duration, totalProduction, 
//       productionAtStart, productionAtEnd, Status, 
//       speed, userId, orderId, 
//       shift, stopId, timestamp
//     ) VALUES (
//       ?,?,?,
//       ?,?,?,
//       ?,?,?,
//       ?,?,?,
//       ?,?,?
//     )
//     `
//     const currentUserId = (attendanceData.length>0? attendanceData[0]?.userId:(existingEventData.length>0?existingEventData[0]?.userId:0))
//     const currentStopId = isUndefined(apiResponse.newStopData?.insertId) ? ((existingStopData?.length > 0)? existingStopData[0]?.id:0):apiResponse.newStopData?.insertId;//existingStopData?.length > 0

//     const insertEventParams = [
//       deviceData.Name, deviceData.status==1?"Running":"Stop", deviceData.timestamp,
//       deviceData.timestamp, 0, 0,
//       deviceData.count, deviceData.count, 'In Progress',
//       deviceData.speed, currentUserId, deviceData.orderId, 
//       shiftData[0]?.shiftName, (deviceData.status==1?0:currentStopId), deviceData.timestamp
//     ]
    
//     const neweventData = await performQuery(insertEventQuery, insertEventParams);
//     apiResponse.message.push("Event Created Successful");
//     apiResponse.InsertedEvent = neweventData
//   }
//   else{
//     let duration = (
//       moment.utc(deviceData.timestamp) - 
//       moment.utc(existingEventData[0]?.startTime) 
//     )/1000

//     let productionAtEnd = (existingEventData[0]?.productionAtEnd > deviceData.count)? (existingEventData[0]?.productionAtEnd + deviceData.count):(deviceData.count);
//     let totalProduction = Number(productionAtEnd) - Number(existingEventData[0]?.productionAtStart)
//     let speed = Math.round(totalProduction/(duration/60))

//     const updateEventQuery = `
//     UPDATE events SET 
//       endTime=?, duration=?, totalProduction=?,
//       productionAtEnd=?, speed=?, timestamp=? 
//     WHERE 
//       id=?
//     `
//     const updateEventParams = [
//       deviceData.timestamp, duration, totalProduction,
//       productionAtEnd, speed, deviceData.timestamp, 
//       existingEventData[0]?.id
//     ]
    
//     const updateeventData = await performQuery(updateEventQuery, updateEventParams);
//     apiResponse.message.push("Event Updated Successful");
//     apiResponse.event = updateeventData
//   }

//   if(newEventCondition && (existingEventData?.length > 0)){
//     let duration = (
//       moment.utc(deviceData.timestamp) - 
//       moment.utc(existingEventData[0]?.startTime) 
//     )/1000

//     let productionAtEnd = (existingEventData[0]?.productionAtEnd > deviceData.count)? (existingEventData[0]?.productionAtEnd + deviceData.count):(deviceData.count);
//     let totalProduction = Number(productionAtEnd) - Number(existingEventData[0]?.productionAtStart)
//     let speed = Math.round(totalProduction/(duration/60))

//     const updateEventQuery = `
//     UPDATE events SET 
//       Status=?, endTime=?,
//       duration=?, totalProduction=?,
//       productionAtEnd=?,
//       speed=?, timestamp=? 
//     WHERE 
//       id=?
//     `
//     const updateEventParams = [
//       "Completed", deviceData.timestamp,
//       duration, totalProduction,
//       productionAtEnd,
//       speed, deviceData.timestamp, 
//       existingEventData[0]?.id
//     ]
    
//     const updateeventData = await performQuery(updateEventQuery, updateEventParams);
//     apiResponse.message.push("Event Updated Successful");
//     apiResponse.event = updateeventData
//   }

  

//   res.status(200).send({
//     message: "Success",
//     data: apiResponse
//   });
      
// });



router.post("/insertDataNew", async (req, res) => {
  const deviceData = {
    Name: req.body.deviceId,
    timestamp: req.body.timestamp || new Date(),
    status: Number(req.body.d1),
    count: Number(req.body.v2),
    qtyinKg: Number(req.body.v3),
    speed: Number(req.body.machineSpeed),
    activePO: req.body.runningPO || "",
    SKU: req.body.SKU || "",
    SKUTarget: Number(req.body.SKUTarget) || 500,
    orderId: Number(req.body.orderId) || 0,
    shift: req.body.currentShift,
  };

  const timestamp = moment.utc(deviceData.timestamp, "MM/DD/YYYY HH:mm:ss");
  const cShiftStart = moment(moment.utc(deviceData.timestamp).format("MM/DD/YYYY") + " 00:00:01").format("MM/DD/YYYY HH:mm:ss");
  const dayEndTimestamp = moment(moment.utc(deviceData.timestamp).format("MM/DD/YYYY") + " 07:00:00").format("MM/DD/YYYY HH:mm:ss");
  console.log(dayEndTimestamp);
  // Check if time is between 00:00:00 and 06:59:59
  if (timestamp.hour() < 7) {
      // Subtract one day
      timestamp.subtract(1, 'days');
  }

  console.log("deviceData >>> ", deviceData);
  apiResponse.deviceData = deviceData

  const selectShiftQuery = `
  SELECT *
  FROM Shift
  WHERE (
          TIME(STR_TO_DATE(startTime, '%H:%m:%s')) <= ?
          AND TIME(STR_TO_DATE(endTime, '%H:%m:%s')) > ?
        )
        OR (
          TIME(STR_TO_DATE(startTime, '%H:%m:%s')) > TIME(STR_TO_DATE(endTime, '%H:%m:%s')) 
          AND (
              TIME(?) >= TIME(STR_TO_DATE(startTime, '%H:%m:%s'))
              OR TIME(?) < TIME(STR_TO_DATE(endTime, '%H:%m:%s'))
            )
        )  
  `;
  const shiftQueryParams = [moment.utc(deviceData.timestamp).format("HH:mm:ss"),moment.utc(deviceData.timestamp).format("HH:mm:ss"),moment.utc(deviceData.timestamp).format("HH:mm:ss"),moment.utc(deviceData.timestamp).format("HH:mm:ss")];
  
  // Perform the database query
  
  const selectAttendance=`
  SELECT * FROM attendance WHERE
  deviceName=? AND 
  STR_TO_DATE(punchIn, '%m/%d/%Y %H:%i:%s') <= STR_TO_DATE(?, '%m/%d/%Y %H:%i:%s') AND 
  (
    STR_TO_DATE(punchOut, '%m/%d/%Y %H:%i:%s') >= STR_TO_DATE(?, '%m/%d/%Y %H:%i:%s') OR 
    punchOut IS NULL
  ) 
  `
  const attendanceQueryParams = [deviceData.Name, deviceData.timestamp, deviceData.timestamp]
  
  const shiftData = await performQuery(selectShiftQuery, shiftQueryParams);
  console.log("shiftData >>> ",shiftData);

  const attendanceData = await performQuery(selectAttendance, attendanceQueryParams);
  console.log("attendanceData >>> ",attendanceData);
  
  const query = {
    insertDeviceData:`
    INSERT INTO DeviceData (
      deviceName,deviceStatus,productCount,poNumber, skuName,
      skuTarget,orderId,timestamp, machineSpeed,qtyInKg
    )
    VALUES (
      ?, ?, ?, ?, ?, 
      ?, ?, ?, ?, ?
    )`,

    deviceDataParams: [
      deviceData.Name, deviceData.status, deviceData.count, deviceData.activePO, deviceData.SKU, 
      deviceData.SKUTarget, deviceData.orderId, deviceData.timestamp, deviceData.speed, deviceData.qtyinKg
    ],
    
    selectCompleteOrders: `
    SELECT * FROM CompleteOrders where (
      deviceName = ? AND
      poNumber = ? AND
      skuName = ? AND
      shiftName = ? AND
      orderId = ? AND
      (
        DATE(STR_TO_DATE(plannedStart,'%m/%d/%Y')) = ? OR 
        (
          STR_TO_DATE(plannedStart,'%m/%d/%Y %H:%i:%s') >= STR_TO_DATE(?,'%m/%d/%Y %H:%i:%s') AND
          STR_TO_DATE(plannedStart,'%m/%d/%Y %H:%i:%s') <= STR_TO_DATE(?,'%m/%d/%Y %H:%i:%s')
        )
      )
    ) ORDER BY id DESC`,

    completeOrderParams:[
      deviceData.Name, deviceData.activePO, 
      deviceData.SKU, shiftData[0]?.shiftName, 
      deviceData.orderId, moment.utc(timestamp).format("YYYY-MM-DD"), 
      cShiftStart, dayEndTimestamp],


    // selectStop:`
    // SELECT * FROM Stops where (
    //   status = 'In Progress' AND
    //   shiftName = ? AND
    //   orderId = ? AND
    //   userId = ? AND
    //   (DATE(STR_TO_DATE(orderStart,'%m/%d/%Y')) = ? OR STR_TO_DATE(orderStart,'%m/%d/%Y %H:%i:%s') <= STR_TO_DATE(?,'%m/%d/%Y %H:%i:%s'))
    // ) ORDER BY id DESC`,
    // stopParams:[
    //   shiftData[0]?.shiftName, deviceData.orderId, 
    //   moment.utc(timestamp).format("YYYY-MM-DD"), dayEndTimestamp
    // ],

    selectStop:`
    SELECT * FROM Stops where (
      deviceName = ? AND
      status = 'In Progress'
    ) 
    ORDER BY id DESC`,
    stopParams:[
      deviceData.Name
    ],

    selectEvents:`SELECT * FROM events WHERE Status = "In Progress"`,

  }

  const insertedDeviceData = await performQuery(query.insertDeviceData, query.deviceDataParams);
  console.log("insertedDeviceData >>> ",insertedDeviceData);


  console.log(query.selectCompleteOrders);
  console.log(query.completeOrderParams);
  const completeOrderData = await performQuery(query.selectCompleteOrders, query.completeOrderParams);
  console.log("completeOrderData >>> ",completeOrderData);
  
  const existingStopData = await performQuery(query.selectStop, query.stopParams);
  console.log("existingStopData >>> ",existingStopData);
  
  const existingEventData = await performQuery(query.selectEvents, []);
  console.log("eventData >>> ",existingEventData);
  
  apiResponse.currentShift = shiftData
  apiResponse.attendance = attendanceData
  apiResponse.newDeviceData = insertedDeviceData
  apiResponse.completedOrders = completeOrderData
  apiResponse.stops = existingStopData
  apiResponse.event = existingEventData

  // Update / Create Complete Order Record
  if(completeOrderData?.length > 0){
    console.log("Update Complete Order");
    // Update Complete Order
    apiResponse.message.push("Updating Complete Order Query ");
    const updateCompleteOrderQuery = `
      UPDATE CompleteOrders SET 
      productCount=?,
      deviceStatus=?,
      plannedEnd=?,
      qtyInKg=?,
      timestamp=? 
      WHERE 
      id= ?
    `
    const updateCompleteOrderParams = [deviceData.count, deviceData.status, moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss"), deviceData.qtyinKg, moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss"), completeOrderData[0].id]

    completeOrderData[0].productCount = deviceData.count
    completeOrderData[0].deviceStatus = deviceData.status
    completeOrderData[0].plannedEnd = moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss")
    completeOrderData[0].qtyInKg = deviceData.qtyinKg
    completeOrderData[0].timestamp = moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss")
    
    const newCompleteOrdersData = await performQuery(updateCompleteOrderQuery, updateCompleteOrderParams);
    apiResponse.message.push("Updating Complete Order Successful, ID: ", completeOrderData[0].id);
    apiResponse.newCompletedOrders = newCompleteOrdersData
  }
  else{
    console.log("Create Complete Order");
    // Insert Complete Order Record
    apiResponse.message.push("Insert Complete Order");
    const InsertCompleteOrderQuery = `
      INSERT INTO CompleteOrders (
        deviceName,  productCount,  deviceStatus, poNumber,  
        skuName,  skuTarget, shiftName,  plannedStart,  
        plannedEnd, orderCompletionStatus, orderId, shiftStartTime,  
        shiftEndTime,  qtyInKg, timestamp
      ) 
      VALUES (
        ?,?,?,?,
        ?,?,?,?,
        ?,?,?,?,
        ?,?,?
      )
    `
    const insertCompleteOrderParams = [
      deviceData.Name, deviceData.count, deviceData.status, deviceData.activePO, 
      deviceData.SKU, deviceData.SKUTarget, shiftData[0]?.shiftName, moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss"), 
      moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss"), '1', deviceData.orderId, shiftData[0]?.startTime, 
      shiftData[0]?.endTime, deviceData.qtyinKg, moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss")]

    completeOrderData.push({
      plannedStart: moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss"),
      plannedEnd: moment.utc(deviceData.timestamp).format("MM/DD/YYYY HH:mm:ss"),
    })
    const newCompleteOrdersData = await performQuery(InsertCompleteOrderQuery, insertCompleteOrderParams);  
    console.log("Complete Order Insert Successfull ID: ", newCompleteOrdersData.insertId);
    apiResponse.message.push("Complete Order Insert Successfull ID: ", newCompleteOrdersData.insertId);
    apiResponse.newCompletedOrders = newCompleteOrdersData
  }

  const deviceCondition = deviceData.status==1?"Running":"Stop"

  if (deviceCondition === "Stop"){
    
    // Calculation for Stop
    // Condition for New Stop
    let orderStart = moment.utc(existingStopData?.[0]?.orderStart)
    let plannedStart = moment.utc(completeOrderData?.[0]?.plannedStart)
    let stopCond1 = existingStopData?.length === 0 // If No Stop is detected
    let stopCond2 = existingStopData[0]?.shiftName !== shiftData[0]?.shiftName // if Shift is Changed
    let stopCond3 = existingStopData[0]?.userId !== (attendanceData.length>0? attendanceData[0]?.userId:existingStopData[0]?.userId) // if user is changeed
    let stopCond4 = existingStopData[0]?.orderId !== deviceData.orderId // if order is changed
    let stopCond5 = Math.abs(orderStart - plannedStart) !== 0 // if Order does not match

    // console.log("orderStart > ", orderStart);
    // console.log("plannedStart > ", plannedStart);
    // console.log("test > ", orderStart-plannedStart);
    console.log("Stop Condition1 > ", stopCond1);
    console.log("Stop Condition2 > ", stopCond2);
    console.log("Stop Condition3 > ", stopCond3);
    console.log("Stop Condition4 > ", stopCond4);
    console.log("Stop Condition5 > ", stopCond5);
    
    const newStopCondition = stopCond1 || (stopCond2 || stopCond3 || stopCond4 || stopCond5)
    
    console.log("newStopCondition > ", newStopCondition);
    
    let downtime
    if(!stopCond1){
      downtime = (
        moment.utc(deviceData.timestamp) - 
        moment.utc(existingStopData[0].startTime) 
      )/1000
    }

    const currentUserId = (attendanceData.length>0? attendanceData[0]?.userId:(existingStopData.length>0?existingStopData[0]?.userId:0))
    

    if(newStopCondition){
      // Create a New Stop
      console.log("Insert New Stop");
      apiResponse.message.push("Insert New Stop");
      const InsertStopQuery = `
      INSERT INTO Stops (
        startTime, endTime, downTime, 
        orderStart, orderEnd, categoryName, 
        subCategoryName, childDeviceName, deviceName, 
        shiftName, shiftStartTime, shiftEndTime, 
        deviceDataId, orderId, skuName, 
        userId, Status
      ) 
      VALUES (
        ?,?,?,
        ?,?,?,
        ?,?,?,
        ?,?,?,
        ?,?,?,
        ?,?
      )
      `
      const InsertStopParams = [
        moment.utc(deviceData.timestamp).toISOString(), moment.utc(deviceData.timestamp).toISOString(), 0,
        completeOrderData[0]?.plannedStart, completeOrderData[0]?.plannedEnd, 0 , 
        'Unreported',deviceData.Name, deviceData.Name, 
        shiftData[0]?.shiftName, shiftData[0]?.startTime, shiftData[0]?.endTime, 
        insertedDeviceData.insertId, deviceData.orderId, deviceData.SKU,
        currentUserId, 'In Progress'
      ]
      
      const newStopData = await performQuery(InsertStopQuery, InsertStopParams);  
      apiResponse.message.push("Stop Inserted Successfull");
      apiResponse.newStopData = newStopData
    }
    else{
      // Update Existing Stop
      apiResponse.message.push("Updating Stop Query ");
      const updateStopQuery = `
        UPDATE Stops SET 
        endTime=?,
        orderEnd=?,
        downTime=?,
        Status=? 
        WHERE 
        id= ?
      `
      const updateStopParams = [
        moment.utc(deviceData.timestamp).toISOString(), completeOrderData[0].plannedEnd, 
        downtime, "In Progress", existingStopData[0].id]

      const updatedStopData = await performQuery(updateStopQuery, updateStopParams);  
      apiResponse.message.push("Stop Updated Successful");
      apiResponse.updatedStopData = updatedStopData
    }

    if(newStopCondition && !stopCond1){
      // Close existing Stop
      
      // Update Existing Stop
      apiResponse.message.push("Updating Stop Query ");
      const updateStopQuery = `
        UPDATE Stops SET 
        endTime=?,
        orderEnd=?,
        downTime=?,
        Status=? 
        WHERE 
        id= ?
      `
      const updateStopParams = [
        moment.utc(deviceData.timestamp).toISOString(), completeOrderData[0].plannedEnd, 
        downtime, "Completed", existingStopData[0].id]

      const updatedStopData = await performQuery(updateStopQuery, updateStopParams);  
      apiResponse.message.push("Stop Updated Successful");
      apiResponse.updatedStopData = updatedStopData
  
    }
  }
  else if(existingStopData?.length !== 0){
    // Update and Close Existing Stop
    let downtime = (
        moment.utc(deviceData.timestamp) - 
        moment.utc(existingStopData[0].startTime) 
      )/1000

    // Update Existing Stop
    apiResponse.message.push("Updating Stop Query ");
    const updateStopQuery = `
      UPDATE Stops SET 
      endTime=?,
      orderEnd=?,
      downTime=?,
      Status=? 
      WHERE 
      id= ?
    `
    const updateStopParams = [
      moment.utc(deviceData.timestamp).toISOString(), completeOrderData[0].plannedEnd, 
      downtime, "Completed", existingStopData[0].id]

    const updatedStopData = await performQuery(updateStopQuery, updateStopParams);  
    apiResponse.message.push("Stop Updated Successful");
    apiResponse.updatedStopData = updatedStopData
  }


  // console.log(" deviceData.status===0 >>> ", deviceData.status==="0");
  // Update / Create Stop Record
  // if(existingStopData?.length > 0){
  //   let downtime = (
  //     moment.utc(deviceData.timestamp) - 
  //     moment.utc(existingStopData[0].startTime) 
  //   )/1000

  //   apiResponse.message.push("Updating Stop Query ");
  //   const updateStopQuery = `
  //     UPDATE Stops SET 
  //     endTime=?,
  //     orderEnd=?,
  //     downTime=?,
  //     Status=? 
  //     WHERE 
  //     id= ?
  //   `
  //   const updateStopParams = [
  //     moment.utc(deviceData.timestamp).toISOString(), completeOrderData[0].plannedEnd, 
  //     downtime, deviceData.status===1?"Completed":"In Progress", existingStopData[0].id]
    
  //   const updatedStopData = await performQuery(updateStopQuery, updateStopParams);  
  //   apiResponse.message.push("Stop Updated Successful");
  //   apiResponse.updatedStopData = updatedStopData

  // }
  // else if(deviceData.status===0){
  //   console.log("Insert New Stop");
  //   apiResponse.message.push("Insert New Stop");
  //   const InsertStopQuery = `
  //   INSERT INTO Stops (
  //     startTime, endTime, downTime, 
  //     orderStart, orderEnd, categoryName, subCategoryName,
  //     childDeviceName, deviceName, shiftName, 
  //     shiftStartTime, shiftEndTime, deviceDataId, 
  //     orderId, mainStopId, skuName, 
  //     Status
  //   ) 
  //   VALUES (
  //     ?,?,?,?,?,?,
  //     ?,?,?,?,?,?,
  //     ?,?,?,?,?
  //   )
  //   `
  //   const InsertStopParams = [
  //     moment.utc(deviceData.timestamp).toISOString(), moment.utc(deviceData.timestamp).toISOString(), '0',
  //     completeOrderData[0]?.plannedStart, completeOrderData[0]?.plannedEnd, 0 , 'Unreported',
  //     deviceData.Name, deviceData.Name, shiftData[0]?.shiftName,
  //     shiftData[0]?.startTime, shiftData[0]?.endTime, insertedDeviceData.insertId,
  //     deviceData.orderId,'0',deviceData.SKU,
  //     'In Progress'
  //   ]
    
  //   const newStopData = await performQuery(InsertStopQuery, InsertStopParams);  
  //   apiResponse.message.push("Stop Inserted Successfull");
  //   apiResponse.newStopData = newStopData
  // }

  //   const deviceCondition = deviceData.status==1?"Running":"Stop"

//   const eventDate = (existingEventData?.length>0)?moment(existingEventData[0].startTime).format("YYYY-MM-DD"):''
//   const currentDate = moment(timestamp).format("YYYY-MM-DD")
//   // console.log('eventDate > ', eventDate);
//   // console.log('currentDate > ', currentDate);

//   let cond1 = existingEventData?.length === 0
//   let cond2 = existingEventData[0]?.eventName !== deviceCondition
//   let cond3 = existingEventData[0]?.userId !== (attendanceData.length>0? attendanceData[0]?.userId:existingEventData[0]?.userId)
//   let cond4 = existingEventData[0]?.orderId !== deviceData.orderId
//   let cond5 = existingEventData[0]?.shift !== shiftData[0]?.shiftName
//   let cond6 = currentDate > eventDate

//   console.log("cond1 >", cond1);
//   console.log("cond2 >", cond2);
//   console.log("cond3 >", cond3);
//   console.log("cond4 >", cond4);
//   console.log("cond5 >", cond5);
//   console.log("cond6 >", cond6);

//   const newEventCondition = 
//   cond1 || (cond2 || cond3 || cond4 || cond5 || cond6)

  const eventDate = (existingEventData?.length>0)?moment(existingEventData[0].startTime).format("YYYY-MM-DD"):''
  const currentDate = moment(timestamp).format("YYYY-MM-DD")
  console.log('eventDate > ', eventDate);
  console.log('currentDate > ', currentDate);
  // console.log('Date Diff > ', );
  

  let eventCond1 = existingEventData?.length === 0
  let eventCond2 = existingEventData[0]?.eventName !== deviceCondition
  let eventCond3 = existingEventData[0]?.userId !== (attendanceData.length>0? attendanceData[0]?.userId:existingEventData[0]?.userId)
  let eventCond4 = existingEventData[0]?.orderId !== deviceData.orderId
  let eventCond5 = existingEventData[0]?.shift !== shiftData[0]?.shiftName
  let eventCond6 = currentDate > eventDate

  console.log("eventCond1 >", eventCond1);
  console.log("eventCond2 >", eventCond2);
  console.log("eventCond3 >", eventCond3);
  console.log("eventCond4 >", eventCond4);
  console.log("eventCond5 >", eventCond5);
  console.log("eventCond6 >", eventCond6);

  const newEventCondition = 
  eventCond1 || (eventCond2 || eventCond3 || eventCond4 || eventCond5 || eventCond6)

  console.log("newEventCondition >>>",newEventCondition);

  
  if(newEventCondition){
    //Manage Events
    const insertEventQuery = `
    INSERT INTO events (
      deviceName, eventName, startTime, 
      endTime, duration, totalProduction, 
      productionAtStart, productionAtEnd, Status, 
      speed, userId, orderId, 
      shift, stopId, timestamp
    ) VALUES (
      ?,?,?,
      ?,?,?,
      ?,?,?,
      ?,?,?,
      ?,?,?
    )
    `
    const currentUserId = (attendanceData.length>0? attendanceData[0]?.userId:(existingEventData.length>0?existingEventData[0]?.userId:0))
    const currentStopId = isUndefined(apiResponse.newStopData?.insertId) ? ((existingStopData?.length > 0)? existingStopData[0]?.id:0):apiResponse.newStopData?.insertId;//existingStopData?.length > 0

    const insertEventParams = [
      deviceData.Name, deviceData.status==1?"Running":"Stop", deviceData.timestamp,
      deviceData.timestamp, 0, 0,
      deviceData.count, deviceData.count, 'In Progress',
      deviceData.speed, currentUserId, deviceData.orderId, 
      shiftData[0]?.shiftName, (deviceData.status==1?0:currentStopId), deviceData.timestamp
    ]
    
    const neweventData = await performQuery(insertEventQuery, insertEventParams);
    apiResponse.message.push("Event Created Successful");
    apiResponse.InsertedEvent = neweventData
  }
  else{
    let duration = (
      moment.utc(deviceData.timestamp) - 
      moment.utc(existingEventData[0]?.startTime) 
    )/1000

    let productionAtEnd = (existingEventData[0]?.productionAtEnd > deviceData.count)? (existingEventData[0]?.productionAtEnd + deviceData.count):(deviceData.count);
    let totalProduction = Number(productionAtEnd) - Number(existingEventData[0]?.productionAtStart)
    let speed = Math.round(totalProduction/(duration/60))

    const updateEventQuery = `
    UPDATE events SET 
      endTime=?, duration=?, totalProduction=?,
      productionAtEnd=?, speed=?, timestamp=? 
    WHERE 
      id=?
    `
    const updateEventParams = [
      deviceData.timestamp, duration, totalProduction,
      productionAtEnd, speed, deviceData.timestamp, 
      existingEventData[0]?.id
    ]
    
    const updateeventData = await performQuery(updateEventQuery, updateEventParams);
    apiResponse.message.push("Event Updated Successful");
    apiResponse.event = updateeventData
  }

  if(newEventCondition && (existingEventData?.length > 0)){
    let duration = (
      moment.utc(deviceData.timestamp) - 
      moment.utc(existingEventData[0]?.startTime) 
    )/1000

    let productionAtEnd = (existingEventData[0]?.productionAtEnd > deviceData.count)? (existingEventData[0]?.productionAtEnd + deviceData.count):(deviceData.count);
    let totalProduction = Number(productionAtEnd) - Number(existingEventData[0]?.productionAtStart)
    let speed = Math.round(totalProduction/(duration/60))

    const updateEventQuery = `
    UPDATE events SET 
      Status=?, endTime=?,
      duration=?, totalProduction=?,
      productionAtEnd=?,
      speed=?, timestamp=? 
    WHERE 
      id=?
    `
    const updateEventParams = [
      "Completed", deviceData.timestamp,
      duration, totalProduction,
      productionAtEnd,
      speed, deviceData.timestamp, 
      existingEventData[0]?.id
    ]
    
    const updateeventData = await performQuery(updateEventQuery, updateEventParams);
    apiResponse.message.push("Event Updated Successful");
    apiResponse.event = updateeventData
  }

  

  res.status(200).send({
    message: "Success",
    data: apiResponse
  });
      
});


module.exports = router;
