const express = require("express");
const router = express.Router();
const db = require("../../utils/db");
const moment = require("moment");
const apiResponse = {
  orderid: '',
	activePo: '',
  activeShift: '',
	skuName: '',
	skuTarget: '',
	qtyInKg: '',
	qtyInMeter: '',
	lastProductCount: '',
  resetCounter: 0,
  currentPOStatus: 0,
}

router.post("/getOrderInfo", async (req, res) => {

  const deviceData = {
    Name: req.body.deviceId,
    currentPo: req.body.currentPO || 0,
    timestamp: req.body.timestamp || new Date() 
  };

  const query = {
    currentOrderQuery:`
    SELECT id,poNumber,status,skuName,skuTarget,qtyInKg,qtyInMeter FROM Orders 
    WHERE deviceName = "${deviceData.Name}" and poNumber="${deviceData.currentPo}"`,

    activeOrderQuery:`
    SELECT id,poNumber,status,skuName,skuTarget,qtyInKg,qtyInMeter FROM Orders 
    WHERE deviceName = "${deviceData.Name}" and status = "1"`,

    getShiftQuery:`
    SELECT * FROM Shift
      WHERE (
        TIME(STR_TO_DATE(startTime, '%H:%m:%s')) <= '${moment.utc(deviceData.timestamp).format("HH:mm:ss")}'
        AND TIME(STR_TO_DATE(endTime, '%H:%m:%s')) > '${moment.utc(deviceData.timestamp).format("HH:mm:ss")}'
      )
      OR (
        TIME(STR_TO_DATE(startTime, '%H:%m:%s')) > TIME(STR_TO_DATE(endTime, '%H:%m:%s')) 
        AND (
            TIME('${moment.utc(deviceData.timestamp).format("HH:mm:ss")}') >= TIME(STR_TO_DATE(startTime, '%H:%m:%s'))
            OR TIME('${moment.utc(deviceData.timestamp).format("HH:mm:ss")}') < TIME(STR_TO_DATE(endTime, '%H:%m:%s'))
          )
      );`,
    // getShiftQuery:`
    // SELECT * FROM Shift where 
    // (
    //   TIME(STR_TO_DATE(startTime, '%H:%m:%s')) <= '${moment.utc(deviceData.timestamp).format("HH:mm:ss")}' and 
    //   TIME(STR_TO_DATE(endTime, '%H:%m:%s')) > '${moment.utc(deviceData.timestamp).format("HH:mm:ss")}' 
    // )`,
    
    getHoldOrderQuery:`
    SELECT lastProductCount FROM HoldOrders WHERE 
    deviceName = "${deviceData.Name}"`,
  }



  console.log("Request >>> ",deviceData);
  // console.log("Query >>> ",query);

  await db.getConnection(async (err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      throw err;
    }
    await connection.query(query.currentOrderQuery, (err, currentPODetails) => {
      if (err) {
        connection.release();
        console.log("error from select current order Data >>>", err);
        res.status(404).send({message: "Error in Select current Order Data"});
      } else {
        // console.log("currentPODetails >>> ", currentPODetails);
        connection.query(query.activeOrderQuery, (err, activePODetails) => {
          if (err) {
            connection.release();
            console.log("error from select active order Data >>>", err);
            res.status(404).send({message: "Error in Select active Order Data"});
          } else { 
            // console.log("activePODetails >>> ", activePODetails);
            connection.query(query.getShiftQuery, (err, shiftData) => {
              if (err) {
                connection.release();
                console.log("error from select shift Data >>>", err);
                res.status(404).send({message: "Error in Select shift Data"});
              } else { 
                console.log("shiftData >>> ", shiftData);
                query.getHoldOrderQuery = `
                  SELECT lastProductCount FROM HoldOrders WHERE 
                  deviceName = "${deviceData.Name}" and poNumber = "${activePODetails[0]?.poNumber}"`,
                connection.query(query.getHoldOrderQuery, (err, HoldOrderData) => {
                  connection.release();
                  if (err) {
                    connection.release();
                    console.log("error from select Hold Order Data >>>", err);
                    res.status(404).send({message: "Error in Select Hold Order Data"});
                  } else { 

                    console.log("currentPODetails >>> ", currentPODetails);
                    console.log("activePODetails >>> ", activePODetails);

                    apiResponse.orderid           = activePODetails[0]?.id || 0
                    apiResponse.activePo          = activePODetails[0]?.poNumber || ''
                    apiResponse.activeShift       = shiftData[0]?.shiftName
                    apiResponse.skuName           = activePODetails[0]?.skuName || ''
                    apiResponse.skuTarget         = activePODetails[0]?.skuTarget  || 500
                    apiResponse.qtyInKg           = activePODetails[0]?.qtyInKg || 0 
                    apiResponse.qtyInMeter        = activePODetails[0]?.qtyInMeter || 0
                    apiResponse.lastProductCount  = HoldOrderData[0]?.lastProductCount || 0
                    apiResponse.resetCounter      = currentPODetails[0]?.status > 1 ? 1 : 0
                    apiResponse.currentPOStatus   = currentPODetails[0]?.status || 0

                    res.status(200).send({
                      message: "Success",
                      data: apiResponse,
                    });
                  }
                });
              }
            });
          }
        });
      }
    });
  });
});



module.exports = router;