const express = require("express");
const router = express.Router();
const db = require("../../utils/db");
// const moment = require("moment");
const {
  verifyTokenAndAdmin,
  verifyToken,
} = require("../middleware/verifyToken");

function getConnection() {
  return new Promise((resolve, reject) => {
    db.getConnection((err, connection) => {
      if (err) {
        reject(err);
        return;
      }

      resolve(connection);
    });
  });
}

async function performQuery(sql, params) {
  const connection = await getConnection();

  try {
    return new Promise((resolve, reject) => {
      connection.query(sql, params, (error, results) => {
        if (error) {
          reject(error);
          return;
        }
        resolve(results);
      });
    });
  } finally {
    connection.release();
  }
}

router.get("/getEvents", verifyToken, (req, res) => {
  const id = req.body.id;

  db.getConnection((err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
    }
    const query = `SELECT * FROM events ORDER BY id DESC`;
    connection.query(query, (err, data) => {
      connection.release();
      if (err) {
        console.log("error from select events >>>", err);
        res.status(404).send({
          message: "Error from server",
          error: err,
        });
      } else {
        // console.log("data from select events >>>", data);
        res.status(200).send({
          message: `selected Successfully`,
          data: data,
        });
      }
    });
  });
});

router.get("/getFilterEvents", (req, res) => {
  const startDate = req.query.startDate;
  const endDate = req.query.endDate;
  // console.log("startDate >>>", startDate);
  // console.log("endDate >>>", endDate);

  db.getConnection((err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
    }
    // const query = `SELECT * FROM events WHERE DATE_FORMAT(STR_TO_DATE(endTime, '%m/%d/%Y'),'%Y-%m-%d') >= "${startDate}" AND DATE_FORMAT(STR_TO_DATE(endTime, '%m/%d/%Y'),'%Y-%m-%d') <= "${endDate}" ORDER BY id DESC`;
    // const query = `SELECT * FROM events WHERE STR_TO_DATE(timestamp, '%m/%d/%Y %H:%i:%s') >= STR_TO_DATE('${startDate} 00:00:00', '%m/%d/%Y %H:%i:%s') AND STR_TO_DATE(timestamp, '%m/%d/%Y %H:%i:%s') <= STR_TO_DATE('${endDate} 23:59:59', '%m/%d/%Y %H:%i:%s') ORDER BY id DESC`
    const query = `
    SELECT e.*, o.id AS orderId, o.poNumber, o.expectedCount, o.expectedCount, o.skuName, o.skuTarget, o.createdBy, o.qtyInKg, o.qtyInMeter, o.scrap,
    s.id AS stopId, s.orderStart, s.orderEnd,  s.shiftName, s.categoryName,  s.subCategoryName , s.causeOne, s.causeTwo, s.causeThree, s.causeFour, s.causeFive, s.reasonOne, s.reasonTwo
    FROM events e
    LEFT JOIN Orders o ON e.orderId = o.id
    LEFT JOIN Stops s ON e.stopId = s.id
    WHERE STR_TO_DATE(e.startTime, '%m/%d/%Y %H:%i:%s') >= STR_TO_DATE('${startDate} 07:00:00', '%m/%d/%Y %H:%i:%s') 
    AND STR_TO_DATE(e.endTime, '%m/%d/%Y %H:%i:%s') <= STR_TO_DATE('${endDate} 06:59:59', '%m/%d/%Y %H:%i:%s') 
    ORDER BY e.id ASC`;

    // console.log(query);

    connection.query(query, (err, data) => {
      connection.release();
      if (err) {
        console.log("error from select events >>>", err);
        res.status(404).send({
          message: "Error from server",
          error: err,
        });
      } else {
        // console.log("data from select events >>>", data);
        res.status(200).send({
          message: `selected filter Data Successfully`,
          data: data,
        });
      }
    });
  });
});

router.get("/getFilterEvents1", (req, res) => {
  const { startDate, endDate } = req.query;

  // const startDate = req.query.startDate
  // const endDate = moment(req.query.endDate).add(1,'days').format("MM/DD/YYYY")

  // console.log("startDate >>>", startDate);
  // console.log("endDate >>>", endDate);

  db.getConnection(async (err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
    }
    // const query = `SELECT * FROM events WHERE DATE_FORMAT(STR_TO_DATE(endTime, '%m/%d/%Y'),'%Y-%m-%d') >= "${startDate}" AND DATE_FORMAT(STR_TO_DATE(endTime, '%m/%d/%Y'),'%Y-%m-%d') <= "${endDate}" ORDER BY id DESC`;
    // const query = `SELECT * FROM events WHERE STR_TO_DATE(timestamp, '%m/%d/%Y %H:%i:%s') >= STR_TO_DATE('${startDate} 00:00:00', '%m/%d/%Y %H:%i:%s') AND STR_TO_DATE(timestamp, '%m/%d/%Y %H:%i:%s') <= STR_TO_DATE('${endDate} 23:59:59', '%m/%d/%Y %H:%i:%s') ORDER BY id DESC`
    const query = `
    SELECT 
	    e.deviceName, e.eventName, e.startTime, e.endTime, e.duration, e.speed, e.shift, e.totalProduction, e.comments, e.Status,
      u.id AS userId, u.username,
	    o.id AS orderId, o.poNumber, o.plannedStart, o.plannedEnd, o.description, o.skuName, o.skuTarget, o.qtyInMeter, 
	    s.id AS stopId, s.categoryName, s.subCategoryName, s.comment
    FROM events e
      LEFT JOIN Orders o ON e.orderId = o.id
      LEFT JOIN Stops s ON e.stopId = s.id
      LEFT JOIN Users u ON e.userId = u.id
    WHERE 
      STR_TO_DATE(e.startTime, '%m/%d/%Y %H:%i:%s') >= STR_TO_DATE('${startDate} 07:00:00', '%m/%d/%Y %H:%i:%s') 
      AND STR_TO_DATE(e.endTime, '%m/%d/%Y %H:%i:%s') <= STR_TO_DATE('${endDate} 07:00:19', '%m/%d/%Y %H:%i:%s') 
    ORDER BY 
      e.id ASC`;

    // console.log(query);

    await connection.query(query, (err, data) => {
      // console.log("Err: ", err);
      // console.log("data: ", data);
      if (err) {
        connection.release();
        console.log("error from select events >>>", err);
        res.status(404).send({
          message: "Error from server",
          error: err,
        });
      } else {
        connection.release();
        console.log("data from select events >>>", data.length);
        res.status(200).send({
          message: `selected filter Data Successfully`,
          data: data,
        });
      }
    });
  });
});

router.get("/getFilterEvents2", async (req, res) => {
  const { startDate, endDate } = req.query;
  // console.log("startDate >>>", startDate);
  // console.log("endDate >>>", endDate);

  const dateQuery = `
  SELECT DISTINCT STR_TO_DATE(startTime, '%m/%d/%Y') as day FROM events 
  WHERE 
    STR_TO_DATE(startTime, '%m/%d/%Y %H:%i:%s') >= STR_TO_DATE('${startDate} 07:00:00', '%m/%d/%Y %H:%i:%s') AND 
    STR_TO_DATE(endTime, '%m/%d/%Y %H:%i:%s') <= STR_TO_DATE('${endDate} 07:00:00', '%m/%d/%Y %H:%i:%s')`;

  const dates = await performQuery(dateQuery, []);
  // console.log("dates >>> ", dates);
  res.status(200).send({
    message: `selected filter Data Successfully`,
    data: dates,
  });
});

module.exports = router;
