const express = require("express");
const router = express.Router();
const db = require("../../utils/db");
const moment = require("moment");
const {
  verifyTokenAndAdmin,
  verifyToken,
} = require("../middleware/verifyToken");
const { forEach, min, max } = require("lodash");

router.get("/getStops", verifyToken, (req, res) => {
  const id = req.body.id;
  const deviceName = req.query?.deviceName;

  db.getConnection((err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      throw err;
    }
    const query = deviceName
      ? `SELECT * FROM Stops WHERE deviceName="${deviceName}" order by id DESC  LIMIT 50`
      : `SELECT * FROM Stops order by id DESC  LIMIT 50`;
    connection.query(query, (err, data) => {
      connection.release();
      if (err) {
        console.log("error from select Stops >>>", err);
        res.status(401).send({
          message: `selected error`,
          error: err,
        });
      } else {
        // console.log("data from select Stops >>>", data);
        res.status(200).send({
          message: `selected Successfully`,
          data: data,
        });
      }
    });
  });
});

// router.get("/getStopsByMachineAndStartTime", verifyToken, (req, res) => {
router.get("/getStopsByMachineAndStartTime", (req, res) => {
  const deviceName = req.query.deviceName;
  const orderStart = req.query.plannedStart;

  db.getConnection((err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      throw err;
    }
    const query = `SELECT * FROM Stops WHERE deviceName="${deviceName}" AND orderStart="${orderStart}" ORDER BY startTime DESC`;
    console.log(`Select Query >>> ${query}`);
    connection.query(query, (err, data) => {
      connection.release();
      if (err) {
        console.log("error from select Stops >>>", err);
        res.status(401).send({
          message: `selected error`,
          error: err,
        });
      } else {
        console.log(`Stops Data >>> ${data}`);
        res.status(200).send({
          message: `selected Successfully`,
          data: data,
        });
      }
    });
  });
});

router.post("/getStopsByDate", verifyToken, (req, res) => {
  const startDate = req.body.startDate;
  const endDate = req.body.endDate;
  console.log("startDate >>>", startDate);
  console.log("endDate >>>", endDate);

  if (startDate === endDate) {
    console.log("both equal >>>");

    db.getConnection((err, connection) => {
      if (err) {
        console.log("database not connected error: >>>", err);
        throw err;
      }
      const selectStopsByDateEqual = `select * from Stops WHERE orderStart > '${startDate} 07:00:00' AND orderStart<'${endDate} 23:00:00'`;
      connection.query(selectStopsByDateEqual, (err, result) => {
        connection.release();
        if (err) {
          res.status(500).send({
            message: "Some error in order selection",
            data: [],
          });
        } else {
          res.status(200).send({
            message: "Stops selected Successfully",
            data: result,
          });
        }
      });
    });
  } else {
    db.getConnection((err, connection) => {
      if (err) {
        console.log("database not connected error: >>>", err);
        throw err;
      }

      const selectStopsByDate = `select * from Stops WHERE (orderStart > '${startDate} 07:00:00' AND orderStart<'${endDate} 07:00:00')  ORDER BY id DESC`;
      console.log("selectStopsByDate >>>", selectStopsByDate);
      connection.query(selectStopsByDate, (err, result) => {
        connection.release();
        if (err) {
          res.status(500).send({
            message: "Some error in order selection",
            data: [],
          });
        } else {
          res.status(200).send({
            message: "Stops selected Successfully",
            data: result,
          });
        }
      });
    });
  }
});

// router.get("/getStopsBytimestamp", verifyToken, (req, res) => {
router.post("/getStopsBytimestamp", (req, res) => {
  const deviceName = req.body.deviceName;
  const timestamp = req.body.timestamp;
  console.log("deviceName >>>", deviceName);
  console.log("timestamp >>>", timestamp);

  db.getConnection((err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      throw err;
    }
    const selectStopsBytimestamp = `SELECT * FROM Stops WHERE deviceName="${deviceName}" AND STR_TO_DATE(startTime, '%Y-%m-%dT%T') <= STR_TO_DATE('${timestamp}', '%m/%d/%Y %H:%i:%s') AND STR_TO_DATE(endTime, '%Y-%m-%dT%T') >= STR_TO_DATE('${timestamp}', '%m/%d/%Y %H:%i:%s');`;

    console.log("selectStopsBytimestamp >>> ", selectStopsBytimestamp);
    connection.query(selectStopsBytimestamp, (err, stopByTimestamp) => {
      if (err) {
        connection.release();
        res.status(500).send({
          message: "Some error in order selection",
          data: [],
        });
      } else {
        var selectStopsid = ``;
        if (stopByTimestamp?.length > 0) {
          if (stopByTimestamp[0]?.mainStopId > 0) {
            selectStopsid = `SELECT * FROM Stops where id= '${stopByTimestamp[0]?.mainStopId}' or mainStopId = '${stopByTimestamp[0]?.mainStopId}';`;
          } else {
            selectStopsid = `SELECT * FROM Stops where id= '${stopByTimestamp[0]?.id}' or mainStopId = '${stopByTimestamp[0]?.id}';`;
          }
          connection.query(selectStopsid, (err, result) => {
            connection.release();
            if (err) {
              res.status(500).send({
                message: "Some error in order selection",
                data: [],
              });
            } else {
              res.status(200).send({
                message: "Stops selected Successfully",
                data: result,
              });
            }
          });
        }
      }
    });
  });
});

// router.get ("/createAllStops", async  (req, res) => {
//   const selectCompleteOrderQuery = `SELECT * FROM CompleteOrders ORDER BY id ASC`

//   db.getConnection((err, connection) => {
//     if (err) {
//       console.log("database not connected error: >>>", err);
//       throw err;
//     }
//     connection.query(selectCompleteOrderQuery,  (err, completeOrders) => {
//       connection.release();
//       if (err) {
//         res.status(500).send({
//           message: "Some error in order selection",
//           data: [],
//         });
//       } else {
//         const totalCompletedOrders = completeOrders.length

//         const stops = [];
//         const logs = [];
//         completeOrders.forEach(  (order)=> {
//           // Query to get Device Data against each Complete order
//           const deviceDataQuery = `
//           SELECT id, deviceStatus, machineSpeed, timestamp
//           FROM DeviceData
//           WHERE STR_TO_DATE(timestamp, '%m/%d/%Y %H:%i:%s')
//             BETWEEN STR_TO_DATE('${order.plannedStart}', '%m/%d/%Y %H:%i:%s')
//             AND STR_TO_DATE('${order.plannedEnd}', '%m/%d/%Y %H:%i:%s')
//           GROUP BY timestamp
//           ORDER BY id ASC`;

//           // basic Template of Stop Table
//           const StopDetails = {
//             startTime: "NA",
//             endTime: "NA",
//             downTime: 0,
//             deviceDataId: 0,
//             Status: "Not Initiallize",
//             orderStart: order.plannedStart,
//             orderEnd: order.plannedEnd,
//             categoryName: "Unplanned",
//             deviceName: "P2 - W&H Miraflex",
//             childDeviceName: "P2 - W&H Miraflex",
//             shiftName: order.shiftName,
//             shiftStartTime: order.shiftStartTime,
//             shiftEndTime: order.shiftEndTime,
//             orderId: order.orderId,
//             mainStopId: 0,
//             skuName: order.skuName,
//           }

//           // new connection to database
//           db.getConnection((err, connection) => {
//             if (err) {
//               console.log("database not connected error: >>>", err);
//               throw err;
//             }
//             connection.query(deviceDataQuery, (err, deviceData) => {
//               connection.release();
//               if (err) {
//                 res.status(500).send({
//                   message: "Some error in deviceData selection",
//                   data: [],
//                 });
//               } else {
//                 console.log(`completeOrder: ${order.id}, totalDeviceDataEntries: ${deviceData.length}`);

//                 // Apply Loop on Device Data to process and collect stop information
//                 deviceData.forEach((record)=>{

//                   // If Machine is in off State
//                   if(record.deviceStatus===0){
//                     // Machine Stop for the first Time
//                     if (StopDetails.Status==="Not Initiallize") {
//                       StopDetails.startTime = moment.utc(record.timestamp).toISOString()
//                       StopDetails.deviceDataId = record.id
//                       StopDetails.Status = "In Progress"
//                     }
//                     // machine is previously stop, update endTime and Duration of Stop
//                     else if(StopDetails.Status==="In Progress"){
//                       // logs.push("Stop Continue");
//                       // logs.push("StartTime: ", moment.utc(StopDetails.startTime, "YYYY/MM/DD hh:mm:ss"), Date.parse(moment.utc(StopDetails.startTime, "YYYY/MM/DD hh:mm:ss")));
//                       // logs.push("EndTime: ", moment.utc(moment.utc(record.timestamp).toISOString(), "YYYY/MM/DD hh:mm:ss"), Date.parse(moment.utc(moment.utc(record.timestamp).toISOString(), "YYYY/MM/DD hh:mm:ss")));
//                       StopDetails.endTime = moment.utc(record.timestamp).toISOString()
//                       StopDetails.downTime = (Date.parse(moment.utc(moment.utc(record.timestamp).toISOString(), "YYYY/MM/DD hh:mm:ss")) - Date.parse(moment.utc(StopDetails.startTime, "YYYY/MM/DD hh:mm:ss")))/1000
//                       // logs.push("Duration: ", StopDetails.downTime);
//                     }
//                   }

//                   // If Machine is in on State
//                   else if(record.deviceStatus===1){
//                     // machine was previously in Off State, , update endTime and Duration of Stop
//                     if(StopDetails.Status==="In Progress"){
//                       // logs.push("Stop Close");
//                       StopDetails.endTime = moment.utc(record.timestamp).toISOString()
//                       StopDetails.downTime = (Date.parse(moment.utc(moment.utc(record.timestamp).toISOString(), "YYYY/MM/DD hh:mm:ss")) - Date.parse(moment.utc(StopDetails.startTime, "YYYY/MM/DD hh:mm:ss")))/1000
//                       StopDetails.Status = "Completed"

//                       // console.log(StopDetails)
//                       stops.push(StopDetails)

//                       StopDetails.startTime= ""
//                       StopDetails.endTime= ""
//                       StopDetails.downTime= 0
//                       StopDetails.deviceDataId= 0
//                       StopDetails.Status= "Not Initiallize"
//                     }
//                   }
//                 });

//                 console.log("stops Count >>> ", stops.length);

//               }
//             })
//           })
//         })

//         res.status(200).send({
//           message: logs,
//           data: stops
//         });
//       }
//     });
//   });
// });

router.get("/createAllStops", async (req, res) => {
  const selectCompleteOrderQuery = `SELECT * FROM CompleteOrders ORDER BY id ASC`;

  db.getConnection(async (err, connection) => {
    if (err) {
      console.error("Database not connected error: >>>", err);
      return res.status(500).send({
        message: "Database connection error",
        data: [],
      });
    }

    try {
      const completeOrders = await new Promise((resolve, reject) => {
        connection.query(selectCompleteOrderQuery, (err, results) => {
          connection.release();
          if (err) {
            reject(err);
          } else {
            resolve(results); // directly resolve results without destructuring
          }
        });
      });

      if (completeOrders.length === 0) {
        res.status(200).send({
          message: "No orders found",
          data: [],
        });
        return;
      }

      const stops = [];
      const logs = [];

      // Process each order asynchronously and gather all promises
      const promises = completeOrders.map((order) =>
        processOrder(order, db, stops, logs)
      );

      // Wait for all orders to be processed
      await Promise.all(promises);

      // Send back the logs and stops
      res.status(200).send({
        message: logs,
        data: stops,
      });
    } catch (error) {
      console.error("Error processing orders: ", error);
      res.status(500).send({
        message: "Failed to process orders",
        data: [],
      });
    }
  });
});

async function processOrder(order, db, stops, logs) {
  const deviceDataQuery = `
      SELECT id, deviceStatus, machineSpeed, timestamp
      FROM DeviceData
      WHERE STR_TO_DATE(timestamp, '%m/%d/%Y %H:%i:%s')
        BETWEEN STR_TO_DATE('${order.plannedStart}', '%m/%d/%Y %H:%i:%s')
        AND STR_TO_DATE('${order.plannedEnd}', '%m/%d/%Y %H:%i:%s')
      GROUP BY timestamp
      ORDER BY id ASC`;

  return new Promise((resolve, reject) => {
    db.getConnection((err, connection) => {
      if (err) {
        console.log("Database not connected error: >>>", err);
        return reject(err);
      }
      connection.query(deviceDataQuery, (err, deviceData) => {
        connection.release();
        if (err) {
          reject(err);
        } else {
          let StopDetails = {
            startTime: "NA",
            endTime: "NA",
            downTime: 0,
            deviceDataId: 0,
            Status: "Not Initiallize",
            orderStart: order.plannedStart,
            orderEnd: order.plannedEnd,
            categoryName: "Unplanned",
            deviceName: "P2 - W&H Miraflex",
            childDeviceName: "P2 - W&H Miraflex",
            shiftName: order.shiftName,
            shiftStartTime: order.shiftStartTime,
            shiftEndTime: order.shiftEndTime,
            orderId: order.orderId,
            mainStopId: 0,
            skuName: order.skuName,
          };

          deviceData.forEach((record) => {
            const recordTimestamp = moment.utc(record.timestamp).toISOString();

            if (record.deviceStatus === 0) {
              if (StopDetails.Status === "Not Initiallize") {
                StopDetails.startTime = recordTimestamp;
                StopDetails.deviceDataId = record.id;
                StopDetails.Status = "In Progress";
              } else if (StopDetails.Status === "In Progress") {
                StopDetails.endTime = recordTimestamp;
                StopDetails.downTime =
                  (Date.parse(StopDetails.endTime) -
                    Date.parse(StopDetails.startTime)) /
                  1000;
              }
            } else if (
              record.deviceStatus === 1 &&
              StopDetails.Status === "In Progress"
            ) {
              StopDetails.endTime = recordTimestamp;
              StopDetails.downTime =
                (Date.parse(StopDetails.endTime) -
                  Date.parse(StopDetails.startTime)) /
                1000;
              StopDetails.Status = "Completed";

              stops.push({ ...StopDetails });
              StopDetails = {
                ...StopDetails,
                startTime: "NA",
                endTime: "NA",
                downTime: 0,
                deviceDataId: 0,
                Status: "Not Initiallize",
              };
            }
          });

          resolve();
        }
      });
    });
  });
}

module.exports = router;
