const CronJob = require("node-cron");
const db = require("../db");
const _ = require("lodash");
const moment = require("moment");
const { getDownTime } = require("../../routes/middleware/downtime");
const { sendMail } = require("../sendMail");
const logger = require("../../logger");

exports.initScheduledJobs = () => {
  const scheduledJobFunction = CronJob.schedule("*/5 * * * *", () => {
    console.log("Schedule Function Running");
    try {
      db.getConnection((err, connection) => {
        if (err) {
          console.log("database not connected error: >>>", err);
          throw err;
        }
        const query = `select timestamp from DeviceData ORDER BY id DESC LIMIT 1 `;
        connection.query(query, (err, data) => {
          connection.release();
          if (err) {
            console.log("Error: ", err);
          } else {
            let currentTime = moment.utc().add(5,'hours')
            let lastReadingTime = moment.utc(data?.[0].timestamp)
            let timeDiffinMinutes = (((currentTime-lastReadingTime)/1000)/60)
            const emailBody = `
            <!DOCTYPE html>
            <html>

              <head>
                  <title>Verification Code</title>
              </head>

              <body style="font-family: Arial, sans-serif; background-color: rgb(244, 244, 244); padding: 20px;">
                  <div style="max-width: 600px; margin: 0 auto; background-color: #ffffff; padding: 30px; border-radius: 10px;">
                      <h1 style="color: #333333;"><span style="font-size: 16px;"><strong><u>Dear KOMPASS Team,</u></strong></span></h1>
                      <p><span style="font-size: 14px;">This is an automated notification from the OEE System.</span></p>
                      <p><span style="font-size: 14px;">Please be informed that the OEE System has not received any data from the OEE Device for the past ${timeDiffinMinutes.toFixed(2)} minutes. The last data was received at ${lastReadingTime.format("DD-MMM-YYYY HH:mm:ss")}.</span></p>
                      <p><span style="font-size: 14px;">Please check your internet connectivity, as this is the most likely cause of the interruption in data transmission. Prompt action will help ensure continuous and accurate data reporting.</span></p>
                      <p><span style="font-size: 14px;">Thank you for your immediate attention to this matter.</span></p>
                      <p><span style="font-size: 14px;"><br></span></p>
                      <p><span style="font-size: 14px;">Best regards,</span></p>
                      <p><span style="font-size: 14px;">OEE System</span></p>
                      <p><span style="font-size: 14px;">Automated Notification Service</span></p>
                  </div>
              </body>

            </html>
            `;

            if(timeDiffinMinutes >= 5)
              sendMail("engr.muhammadsaad2016@gmail.com", "[Alert] OEE System Data Transmission Interruption",emailBody)
            else
              console.log("Time Diff > ",timeDiffinMinutes);
              logger.info(`Schedule Function Running`, {
                info : `Time Diff >,${timeDiffinMinutes}`
              });
          }
        });
      });
    } catch (error) {
      console.log("Error in Fetching Device Data: ", error);
    }
  });

  scheduledJobFunction.start();
};


// const selectOrderQuery = `SELECT * FROM Order`;
// connection.query(selectOrderQuery, (err, orderData) => {
//   connection.release();
//   if (err) {
//     console.log("Error from Select Order data", err);
//   } else {
//    console.log("");
//   }
// });
